/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.service.AbstractRowResolver;
import org.apache.cassandra.service.DigestMismatchException;

public class RowDigestResolver
extends AbstractRowResolver {
    public RowDigestResolver(String keyspaceName, ByteBuffer key, int maxResponseCount) {
        super(key, keyspaceName, maxResponseCount);
    }

    @Override
    public Row getData() {
        for (MessageIn message : this.replies) {
            ReadResponse result = (ReadResponse)message.payload;
            if (result.isDigestQuery()) continue;
            return result.row();
        }
        return null;
    }

    @Override
    public Row resolve() throws DigestMismatchException {
        if (logger.isDebugEnabled()) {
            logger.debug("resolving {} responses", (Object)this.replies.size());
        }
        long start = System.nanoTime();
        ColumnFamily data = null;
        ByteBuffer digest = null;
        for (MessageIn message : this.replies) {
            ByteBuffer newDigest;
            ReadResponse response = (ReadResponse)message.payload;
            if (response.isDigestQuery()) {
                newDigest = response.digest();
            } else {
                data = response.row().cf;
                newDigest = ColumnFamily.digest(data);
            }
            if (digest == null) {
                digest = newDigest;
                continue;
            }
            if (digest.equals(newDigest)) continue;
            throw new DigestMismatchException(this.key, digest, newDigest);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("resolve: {} ms.", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        }
        return new Row(this.key, data);
    }

    @Override
    public boolean isDataPresent() {
        for (MessageIn message : this.replies) {
            if (((ReadResponse)message.payload).isDigestQuery()) continue;
            return true;
        }
        return false;
    }
}

