/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IColumnIteratorFactory;
import org.apache.cassandra.db.columniterator.LazyColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class BigTableScanner
implements ISSTableScanner {
    protected final RandomAccessReader dfile;
    protected final RandomAccessReader ifile;
    public final SSTableReader sstable;
    private final Iterator<AbstractBounds<RowPosition>> rangeIterator;
    private AbstractBounds<RowPosition> currentRange;
    private final DataRange dataRange;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    protected Iterator<OnDiskAtomIterator> iterator;

    public static ISSTableScanner getScanner(SSTableReader sstable, DataRange dataRange, RateLimiter limiter) {
        return new BigTableScanner(sstable, dataRange, limiter);
    }

    public static ISSTableScanner getScanner(SSTableReader sstable, Collection<Range<Token>> tokenRanges, RateLimiter limiter) {
        List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(tokenRanges);
        if (positions.isEmpty()) {
            return new EmptySSTableScanner(sstable.getFilename());
        }
        return new BigTableScanner(sstable, tokenRanges, limiter);
    }

    private BigTableScanner(SSTableReader sstable, DataRange dataRange, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = dataRange;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata);
        ArrayList<AbstractBounds<RowPosition>> boundsList = new ArrayList<AbstractBounds<RowPosition>>(2);
        this.addRange(dataRange.keyRange(), boundsList);
        this.rangeIterator = boundsList.iterator();
    }

    private BigTableScanner(SSTableReader sstable, Collection<Range<Token>> tokenRanges, RateLimiter limiter) {
        assert (sstable != null);
        this.dfile = limiter == null ? sstable.openDataReader() : sstable.openDataReader(limiter);
        this.ifile = sstable.openIndexReader();
        this.sstable = sstable;
        this.dataRange = null;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata);
        ArrayList<AbstractBounds<RowPosition>> boundsList = new ArrayList<AbstractBounds<RowPosition>>(tokenRanges.size());
        for (Range<Token> range : Range.normalize(tokenRanges)) {
            this.addRange(Range.makeRowRange(range), boundsList);
        }
        this.rangeIterator = boundsList.iterator();
    }

    private void addRange(AbstractBounds<RowPosition> requested, List<AbstractBounds<RowPosition>> boundsList) {
        if (requested instanceof Range && ((Range)requested).isWrapAround()) {
            if (((RowPosition)requested.right).compareTo(this.sstable.first) >= 0) {
                AbstractBounds.Boundary<DecoratedKey> left = new AbstractBounds.Boundary<DecoratedKey>(this.sstable.first, true);
                AbstractBounds.Boundary<RowPosition> right = requested.rightBoundary();
                if (!AbstractBounds.isEmpty(left, right = AbstractBounds.minRight(right, this.sstable.last, true))) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
            if (((RowPosition)requested.left).compareTo(this.sstable.last) <= 0) {
                AbstractBounds.Boundary<DecoratedKey> right = new AbstractBounds.Boundary<DecoratedKey>(this.sstable.last, true);
                AbstractBounds.Boundary<RowPosition> left = requested.leftBoundary();
                if (!AbstractBounds.isEmpty(left = AbstractBounds.maxLeft(left, this.sstable.first, true), right)) {
                    boundsList.add(AbstractBounds.bounds(left, right));
                }
            }
        } else {
            assert (((RowPosition)requested.left).compareTo(requested.right) <= 0 || ((RowPosition)requested.right).isMinimum());
            AbstractBounds.Boundary<RowPosition> left = requested.leftBoundary();
            AbstractBounds.Boundary<RowPosition> right = requested.rightBoundary();
            left = AbstractBounds.maxLeft(left, this.sstable.first, true);
            AbstractBounds.Boundary<RowPosition> boundary = right = ((RowPosition)requested.right).isMinimum() ? new AbstractBounds.Boundary<DecoratedKey>(this.sstable.last, true) : AbstractBounds.minRight(right, this.sstable.last, true);
            if (!AbstractBounds.isEmpty(left, right)) {
                boundsList.add(AbstractBounds.bounds(left, right));
            }
        }
    }

    private void seekToCurrentRangeStart() {
        long indexPosition = this.sstable.getIndexScanPosition((RowPosition)this.currentRange.left);
        this.ifile.seek(indexPosition);
        try {
            while (!this.ifile.isEOF()) {
                indexPosition = this.ifile.getFilePointer();
                DecoratedKey indexDecoratedKey = this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(this.ifile));
                if (indexDecoratedKey.compareTo((RowPosition)this.currentRange.left) > 0 || this.currentRange.contains(indexDecoratedKey)) {
                    long dataPosition = this.ifile.readLong();
                    this.ifile.seek(indexPosition);
                    this.dfile.seek(dataPosition);
                    break;
                }
                RowIndexEntry.Serializer.skip(this.ifile);
            }
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Exception)e, this.sstable.getFilename());
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.dfile, this.ifile);
    }

    @Override
    public long getLengthInBytes() {
        return this.dfile.length();
    }

    @Override
    public long getCurrentPosition() {
        return this.dfile.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public OnDiskAtomIterator next() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Iterator<OnDiskAtomIterator> createIterator() {
        return new KeyScanningIterator();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "dfile=" + this.dfile + " ifile=" + this.ifile + " sstable=" + this.sstable + ")";
    }

    public static class EmptySSTableScanner
    implements ISSTableScanner {
        private final String filename;

        public EmptySSTableScanner(String filename) {
            this.filename = filename;
        }

        @Override
        public long getLengthInBytes() {
            return 0L;
        }

        @Override
        public long getCurrentPosition() {
            return 0L;
        }

        @Override
        public String getBackingFiles() {
            return this.filename;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public OnDiskAtomIterator next() {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void remove() {
        }
    }

    protected class KeyScanningIterator
    extends AbstractIterator<OnDiskAtomIterator> {
        private DecoratedKey nextKey;
        private RowIndexEntry nextEntry;
        private DecoratedKey currentKey;
        private RowIndexEntry currentEntry;

        protected KeyScanningIterator() {
        }

        protected OnDiskAtomIterator computeNext() {
            try {
                if (this.nextEntry == null) {
                    do {
                        if (!BigTableScanner.this.rangeIterator.hasNext()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        BigTableScanner.this.currentRange = (AbstractBounds)BigTableScanner.this.rangeIterator.next();
                        BigTableScanner.this.seekToCurrentRangeStart();
                        if (BigTableScanner.this.ifile.isEOF()) {
                            return (OnDiskAtomIterator)this.endOfData();
                        }
                        this.currentKey = BigTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                        this.currentEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.sstable.descriptor.version);
                    } while (!BigTableScanner.this.currentRange.contains(this.currentKey));
                } else {
                    this.currentKey = this.nextKey;
                    this.currentEntry = this.nextEntry;
                }
                if (BigTableScanner.this.ifile.isEOF()) {
                    this.nextEntry = null;
                    this.nextKey = null;
                } else {
                    this.nextKey = BigTableScanner.this.sstable.partitioner.decorateKey(ByteBufferUtil.readWithShortLength(BigTableScanner.this.ifile));
                    this.nextEntry = BigTableScanner.this.rowIndexEntrySerializer.deserialize(BigTableScanner.this.ifile, BigTableScanner.this.sstable.descriptor.version);
                    if (!BigTableScanner.this.currentRange.contains(this.nextKey)) {
                        this.nextKey = null;
                        this.nextEntry = null;
                    }
                }
                if (BigTableScanner.this.dataRange == null || BigTableScanner.this.dataRange.selectsFullRowFor(this.currentKey.getKey())) {
                    BigTableScanner.this.dfile.seek(this.currentEntry.position + this.currentEntry.headerOffset());
                    ByteBufferUtil.readWithShortLength(BigTableScanner.this.dfile);
                    return new SSTableIdentityIterator(BigTableScanner.this.sstable, BigTableScanner.this.dfile, this.currentKey);
                }
                return new LazyColumnIterator(this.currentKey, new IColumnIteratorFactory(){

                    @Override
                    public OnDiskAtomIterator create() {
                        return BigTableScanner.this.dataRange.columnFilter(KeyScanningIterator.this.currentKey.getKey()).getSSTableColumnIterator(BigTableScanner.this.sstable, BigTableScanner.this.dfile, KeyScanningIterator.this.currentKey, KeyScanningIterator.this.currentEntry);
                    }
                });
            }
            catch (IOException | CorruptSSTableException e) {
                BigTableScanner.this.sstable.markSuspect();
                throw new CorruptSSTableException(e, BigTableScanner.this.sstable.getFilename());
            }
        }
    }
}

