/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableRewriter
extends Transactional.AbstractTransactional
implements Transactional {
    private static long preemptiveOpenInterval;
    private final DataTracker dataTracker;
    private final ColumnFamilyStore cfs;
    private final long maxAge;
    private long repairedAt = -1L;
    private final List<SSTableReader> preparedForCommit = new ArrayList<SSTableReader>();
    private final Set<SSTableReader> rewriting;
    private final Map<Descriptor, DecoratedKey> originalStarts = new HashMap<Descriptor, DecoratedKey>();
    private final Map<Descriptor, Integer> fileDescriptors = new HashMap<Descriptor, Integer>();
    private SSTableReader currentlyOpenedEarly;
    private long currentlyOpenedEarlyAt;
    private final List<Finished> finishedWriters = new ArrayList<Finished>();
    private final Set<SSTableReader> discard = new HashSet<SSTableReader>();
    private final boolean isOffline;
    private SSTableWriter writer;
    private Map<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
    private boolean throwEarly;
    private boolean throwLate;

    @VisibleForTesting
    public static void overrideOpenInterval(long size) {
        preemptiveOpenInterval = size;
    }

    @VisibleForTesting
    public static long getOpenInterval() {
        return preemptiveOpenInterval;
    }

    public SSTableRewriter(ColumnFamilyStore cfs, Set<SSTableReader> rewriting, long maxAge, boolean isOffline) {
        this.rewriting = rewriting;
        for (SSTableReader sstable : rewriting) {
            this.originalStarts.put(sstable.descriptor, sstable.first);
            this.fileDescriptors.put(sstable.descriptor, CLibrary.getfd(sstable.getFilename()));
        }
        this.dataTracker = cfs.getDataTracker();
        this.cfs = cfs;
        this.maxAge = maxAge;
        this.isOffline = isOffline;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        this.maybeReopenEarly(row.key);
        RowIndexEntry index = this.writer.append(row);
        if (!this.isOffline) {
            if (index == null) {
                this.cfs.invalidateCachedRow(row.key);
            } else {
                boolean save = false;
                for (SSTableReader reader : this.rewriting) {
                    if (reader.getCachedPosition(row.key, false) == null) continue;
                    save = true;
                    break;
                }
                if (save) {
                    this.cachedKeys.put(row.key, index);
                }
            }
        }
        return index;
    }

    public RowIndexEntry tryAppend(AbstractCompactedRow row) {
        this.writer.mark();
        try {
            return this.append(row);
        }
        catch (Throwable t) {
            this.writer.resetAndTruncate();
            throw t;
        }
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > preemptiveOpenInterval) {
            if (this.isOffline) {
                for (SSTableReader reader : this.rewriting) {
                    RowIndexEntry index = reader.getPosition(key, SSTableReader.Operator.GE);
                    CLibrary.trySkipCache((int)this.fileDescriptors.get(reader.descriptor), 0L, index == null ? 0L : index.position);
                }
            } else {
                SSTableReader reader = this.writer.setMaxDataAge(this.maxAge).openEarly();
                if (reader != null) {
                    this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
                    this.currentlyOpenedEarly = reader;
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader, reader.last, false);
                }
            }
        }
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        try {
            this.moveStarts(null, null, true);
        }
        catch (Throwable t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        for (SSTableReader sstable : this.preparedForCommit) {
            try {
                sstable.markObsolete();
                sstable.selfRef().release();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        if (this.writer != null) {
            this.finishedWriters.add(new Finished(this.writer, this.currentlyOpenedEarly));
        }
        for (Finished finished : this.finishedWriters) {
            accumulate = finished.writer.abort(accumulate);
            if (finished.reader == null) continue;
            this.discard.add(finished.reader);
        }
        accumulate = this.replaceWithFinishedReaders(Collections.emptyList(), accumulate);
        return accumulate;
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        for (Finished f : this.finishedWriters) {
            accumulate = f.writer.commit(accumulate);
        }
        accumulate = this.replaceWithFinishedReaders(this.preparedForCommit, accumulate);
        return accumulate;
    }

    @Override
    protected Throwable doCleanup(Throwable accumulate) {
        return accumulate;
    }

    private void moveStarts(SSTableReader newReader, DecoratedKey lowerbound, boolean reset) {
        if (this.isOffline) {
            return;
        }
        if (preemptiveOpenInterval == Long.MAX_VALUE) {
            return;
        }
        ArrayList<SSTableReader> toReplace = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> replaceWith = new ArrayList<SSTableReader>();
        final ArrayList<DecoratedKey> invalidateKeys = new ArrayList<DecoratedKey>();
        if (!reset) {
            invalidateKeys.addAll(this.cachedKeys.keySet());
            for (Map.Entry entry : this.cachedKeys.entrySet()) {
                newReader.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        this.cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        for (SSTableReader sSTableReader : ImmutableList.copyOf(this.rewriting)) {
            SSTableReader replacement;
            final SSTableReader latest = sSTableReader.getCurrentReplacement();
            if (reset) {
                DecoratedKey newStart = this.originalStarts.get(sSTableReader.descriptor);
                replacement = latest.cloneWithNewStart(newStart, null);
            } else {
                if (latest.openReason == SSTableReader.OpenReason.SHADOWED || latest.first.compareTo(lowerbound) > 0) continue;
                Runnable runOnClose = new Runnable(){

                    @Override
                    public void run() {
                        for (DecoratedKey key : invalidateKeys) {
                            latest.invalidateCacheKey(key);
                        }
                    }
                };
                if (lowerbound.compareTo(latest.last) >= 0) {
                    replacement = latest.cloneAsShadowed(runOnClose);
                } else {
                    DecoratedKey newStart = latest.firstKeyBeyond(lowerbound);
                    assert (newStart != null);
                    replacement = latest.cloneWithNewStart(newStart, runOnClose);
                }
            }
            toReplace.add(latest);
            replaceWith.add(replacement);
            this.rewriting.remove(sSTableReader);
            this.rewriting.add(replacement);
        }
        this.cfs.getDataTracker().replaceWithNewInstances(toReplace, replaceWith);
    }

    private void replaceEarlyOpenedFile(SSTableReader toReplace, SSTableReader replaceWith) {
        Set<SSTableReader> toReplaceSet;
        if (this.isOffline) {
            return;
        }
        if (toReplace != null) {
            toReplace.setReplacedBy(replaceWith);
            toReplaceSet = Collections.singleton(toReplace);
        } else {
            this.dataTracker.markCompacting(Collections.singleton(replaceWith), true, this.isOffline);
            toReplaceSet = Collections.emptySet();
        }
        this.dataTracker.replaceEarlyOpenedFiles(toReplaceSet, Collections.singleton(replaceWith));
    }

    public void switchWriter(SSTableWriter newWriter) {
        if (this.writer == null || this.writer.getFilePointer() == 0L) {
            if (this.writer != null) {
                this.writer.abort();
            }
            this.writer = newWriter;
            return;
        }
        SSTableReader reader = null;
        if (preemptiveOpenInterval != Long.MAX_VALUE) {
            reader = this.writer.setMaxDataAge(this.maxAge).openFinalEarly();
            this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
            this.moveStarts(reader, reader.last, false);
        }
        this.finishedWriters.add(new Finished(this.writer, reader));
        this.currentlyOpenedEarly = null;
        this.currentlyOpenedEarlyAt = 0L;
        this.writer = newWriter;
    }

    public SSTableRewriter setRepairedAt(long repairedAt) {
        this.repairedAt = repairedAt;
        return this;
    }

    @Override
    public List<SSTableReader> finish() {
        super.finish();
        return this.finished();
    }

    public List<SSTableReader> finished() {
        assert (this.state() == Transactional.AbstractTransactional.State.COMMITTED || this.state() == Transactional.AbstractTransactional.State.READY_TO_COMMIT);
        return this.preparedForCommit;
    }

    @Override
    protected void doPrepare() {
        this.switchWriter(null);
        if (this.throwEarly) {
            throw new RuntimeException("exception thrown early in finish, for testing");
        }
        for (Finished f : this.finishedWriters) {
            if (f.reader != null) {
                this.discard.add(f.reader);
            }
            f.writer.setRepairedAt(this.repairedAt).setMaxDataAge(this.maxAge).setOpenResult(true).prepareToCommit();
            SSTableReader newReader = f.writer.finished();
            if (f.reader != null) {
                f.reader.setReplacedBy(newReader);
            }
            this.preparedForCommit.add(newReader);
        }
        if (this.throwLate) {
            throw new RuntimeException("exception thrown after all sstables finished, for testing");
        }
    }

    @VisibleForTesting
    void throwDuringPrepare(boolean throwEarly) {
        this.throwEarly = throwEarly;
        this.throwLate = !throwEarly;
    }

    private Throwable replaceWithFinishedReaders(List<SSTableReader> finished, Throwable accumulate) {
        if (this.isOffline) {
            for (SSTableReader reader : this.discard) {
                try {
                    if (reader.getCurrentReplacement() != reader) continue;
                    reader.markObsolete();
                }
                catch (Throwable t) {
                    accumulate = Throwables.merge(accumulate, t);
                }
            }
            accumulate = Refs.release(Refs.selfRefs(this.discard), accumulate);
        } else {
            try {
                this.dataTracker.replaceEarlyOpenedFiles(this.discard, finished);
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
            try {
                this.dataTracker.unmarkCompacting(this.discard);
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        this.discard.clear();
        return accumulate;
    }

    static {
        long interval = (long)DatabaseDescriptor.getSSTablePreempiveOpenIntervalInMB() * 0x100000L;
        if (interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        preemptiveOpenInterval = interval;
    }

    private static final class Finished {
        final SSTableWriter writer;
        final SSTableReader reader;

        private Finished(SSTableWriter writer, SSTableReader reader) {
            this.writer = writer;
            this.reader = reader;
        }
    }
}

