/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.FileUtils;

public class CompressedSegment
extends CommitLogSegment {
    private static final ThreadLocal<ICompressor.WrappedByteBuffer> compressedBufferHolder = new ThreadLocal<ICompressor.WrappedByteBuffer>(){

        @Override
        protected ICompressor.WrappedByteBuffer initialValue() {
            return new ICompressor.WrappedByteBuffer(ByteBuffer.allocate(0));
        }
    };
    static Queue<ByteBuffer> bufferPool = new ConcurrentLinkedQueue<ByteBuffer>();
    static final int MAX_BUFFERPOOL_SIZE = DatabaseDescriptor.getCommitLogMaxCompressionBuffersInPool();
    static final int COMPRESSED_MARKER_SIZE = 12;
    final ICompressor compressor;
    static long startMillis = System.currentTimeMillis();

    CompressedSegment(CommitLog commitLog) {
        super(commitLog);
        this.compressor = commitLog.compressor;
        try {
            this.channel.write((ByteBuffer)this.buffer.duplicate().flip());
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    static ByteBuffer allocate(ICompressor compressor, int size) {
        if (compressor.useDirectOutputByteBuffers()) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    ByteBuffer allocate(int size) {
        return CompressedSegment.allocate(this.compressor, size);
    }

    @Override
    ByteBuffer createBuffer(CommitLog commitLog) {
        ByteBuffer buf = bufferPool.poll();
        if (buf == null) {
            buf = CompressedSegment.allocate(commitLog.compressor, DatabaseDescriptor.getCommitLogSegmentSize());
        } else {
            buf.clear();
        }
        return buf;
    }

    @Override
    void write(int startMarker, int nextMarker) {
        int contentStart = startMarker + 8;
        int length = nextMarker - contentStart;
        assert (length > 0 || length == 0 && !this.isStillAllocating());
        try {
            int compressedLength = this.compressor.initialCompressedBufferLength(length);
            ICompressor.WrappedByteBuffer wrappedCompressedBuffer = compressedBufferHolder.get();
            ByteBuffer compressedBuffer = wrappedCompressedBuffer.buffer;
            if (compressedBuffer.isDirect() != this.compressor.useDirectOutputByteBuffers() || compressedBuffer.capacity() < compressedLength + 12) {
                compressedBuffer = this.allocate(compressedLength + 12);
                FileUtils.clean(wrappedCompressedBuffer.buffer);
                wrappedCompressedBuffer.buffer = compressedBuffer;
            }
            ByteBuffer inputBuffer = this.buffer.duplicate();
            inputBuffer.limit(contentStart + length).position(contentStart);
            compressedBuffer.limit(compressedBuffer.capacity()).position(12);
            compressedLength = this.compressor.compress(inputBuffer, wrappedCompressedBuffer);
            compressedBuffer.position(0);
            compressedBuffer.limit(12 + compressedLength);
            compressedBuffer.putInt(8, length);
            this.writeSyncMarker(compressedBuffer, 0, (int)this.channel.position(), (int)this.channel.position() + compressedBuffer.remaining());
            this.channel.write(compressedBuffer);
            this.channel.force(true);
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    protected void internalClose() {
        if (bufferPool.size() < MAX_BUFFERPOOL_SIZE) {
            bufferPool.add(this.buffer);
        } else {
            FileUtils.clean(this.buffer);
        }
        super.internalClose();
    }

    static void shutdown() {
        bufferPool.clear();
    }
}

