/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ColumnIdentifier
extends Selectable
implements IMeasurableMemory {
    public final ByteBuffer bytes;
    private final String text;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ColumnIdentifier("", true));

    public ColumnIdentifier(String rawText, boolean keepCase) {
        this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        this.bytes = ByteBufferUtil.bytes(this.text);
    }

    public ColumnIdentifier(ByteBuffer bytes, AbstractType<?> type) {
        this.bytes = bytes;
        this.text = type.getString(bytes);
    }

    public ColumnIdentifier(ByteBuffer bytes, String text) {
        this.bytes = bytes;
        this.text = text;
    }

    public final int hashCode() {
        return this.bytes.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier that = (ColumnIdentifier)o;
        return this.bytes.equals(that.bytes);
    }

    public String toString() {
        return this.text;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.bytes) + ObjectSizes.sizeOf(this.text);
    }

    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.bytes) + ObjectSizes.sizeOf(this.text);
    }

    public ColumnIdentifier clone(AbstractAllocator allocator) {
        return new ColumnIdentifier(allocator.clone(this.bytes), this.text);
    }

    @Override
    public Selector.Factory newSelectorFactory(CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        ColumnDefinition def = cfm.getColumnDefinition(this);
        if (def == null) {
            throw new InvalidRequestException(String.format("Undefined name %s in selection clause", this));
        }
        return SimpleSelector.newFactory(def.name.toString(), ColumnIdentifier.addAndGetIndex(def, defs), def.type);
    }

    public static class Raw
    implements Selectable.Raw {
        private final String rawText;
        private final String text;

        public Raw(String rawText, boolean keepCase) {
            this.rawText = rawText;
            this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        }

        @Override
        public ColumnIdentifier prepare(CFMetaData cfm) {
            AbstractType<?> comparator = cfm.comparator.asAbstractType();
            if (cfm.getIsDense().booleanValue() || comparator instanceof CompositeType || comparator instanceof UTF8Type) {
                return new ColumnIdentifier(this.text, true);
            }
            ByteBuffer bufferName = ByteBufferUtil.bytes(this.text);
            for (ColumnDefinition def : cfm.partitionKeyColumns()) {
                if (!def.name.bytes.equals(bufferName)) continue;
                return new ColumnIdentifier(this.text, true);
            }
            return new ColumnIdentifier(comparator.fromString(this.rawText), this.text);
        }

        @Override
        public boolean processesSelection() {
            return false;
        }

        public final int hashCode() {
            return this.text.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Raw)) {
                return false;
            }
            Raw that = (Raw)o;
            return this.text.equals(that.text);
        }

        public String toString() {
            return this.text;
        }
    }
}

