/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.schema.LegacySchemaTables;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.ConcurrentBiMap;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final Schema instance = new Schema();
    public static final int NAME_LENGTH = 48;
    private final Map<String, KSMetaData> keyspaces = new NonBlockingHashMap();
    private final Map<String, Keyspace> keyspaceInstances = new NonBlockingHashMap();
    private final ConcurrentBiMap<Pair<String, String>, UUID> cfIdMap = new ConcurrentBiMap();
    private volatile UUID version;
    public static final UUID emptyVersion;

    public Schema() {
        this.load(SystemKeyspace.definition());
    }

    public Schema loadFromDisk() {
        return this.loadFromDisk(true);
    }

    public Schema loadFromDisk(boolean updateVersion) {
        this.load(LegacySchemaTables.readSchemaFromSystemTables());
        if (updateVersion) {
            this.updateVersion();
        }
        return this;
    }

    public Schema load(Collection<KSMetaData> keyspaceDefs) {
        for (KSMetaData def : keyspaceDefs) {
            this.load(def);
        }
        return this;
    }

    public Schema load(KSMetaData keyspaceDef) {
        for (CFMetaData cfm : keyspaceDef.cfMetaData().values()) {
            this.load(cfm);
        }
        this.setKeyspaceDefinition(keyspaceDef);
        return this;
    }

    public Keyspace getKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.get(keyspaceName);
    }

    public ColumnFamilyStore getColumnFamilyStoreInstance(UUID cfId) {
        Pair<String, String> pair = this.cfIdMap.inverse().get(cfId);
        if (pair == null) {
            return null;
        }
        Keyspace instance = this.getKeyspaceInstance((String)pair.left);
        if (instance == null) {
            return null;
        }
        return instance.getColumnFamilyStore(cfId);
    }

    public void storeKeyspaceInstance(Keyspace keyspace) {
        if (this.keyspaceInstances.containsKey(keyspace.getName())) {
            throw new IllegalArgumentException(String.format("Keyspace %s was already initialized.", keyspace.getName()));
        }
        this.keyspaceInstances.put(keyspace.getName(), keyspace);
    }

    public Keyspace removeKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.remove(keyspaceName);
    }

    public void clearKeyspaceDefinition(KSMetaData ksm) {
        this.keyspaces.remove(ksm.name);
    }

    public CFMetaData getCFMetaData(String keyspaceName, String cfName) {
        assert (keyspaceName != null);
        KSMetaData ksm = this.keyspaces.get(keyspaceName);
        return ksm == null ? null : ksm.cfMetaData().get(cfName);
    }

    public CFMetaData getCFMetaData(UUID cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public KSMetaData getKSMetaData(String keyspaceName) {
        assert (keyspaceName != null);
        return this.keyspaces.get(keyspaceName);
    }

    public List<String> getNonSystemKeyspaces() {
        return ImmutableList.copyOf((Collection)Sets.difference(this.keyspaces.keySet(), Collections.singleton("system")));
    }

    public Map<String, CFMetaData> getKeyspaceMetaData(String keyspaceName) {
        assert (keyspaceName != null);
        KSMetaData ksm = this.keyspaces.get(keyspaceName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public Set<String> getKeyspaces() {
        return this.keyspaces.keySet();
    }

    public Collection<KSMetaData> getKeyspaceDefinitions() {
        return this.keyspaces.values();
    }

    public void setKeyspaceDefinition(KSMetaData ksm) {
        assert (ksm != null);
        this.keyspaces.put(ksm.name, ksm);
    }

    public Pair<String, String> getCF(UUID cfId) {
        return this.cfIdMap.inverse().get(cfId);
    }

    public boolean hasCF(UUID cfId) {
        return this.cfIdMap.containsValue(cfId);
    }

    public UUID getId(String ksName, String cfName) {
        return this.cfIdMap.get(Pair.create(ksName, cfName));
    }

    public void load(CFMetaData cfm) {
        Pair<String, String> key = Pair.create(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded table %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, cfm.cfId);
    }

    public void purge(CFMetaData cfm) {
        this.cfIdMap.remove(Pair.create(cfm.ksName, cfm.cfName));
        cfm.markPurged();
    }

    public UUID getVersion() {
        return this.version;
    }

    public void updateVersion() {
        this.version = LegacySchemaTables.calculateSchemaDigest();
        SystemKeyspace.updateSchemaVersion(this.version);
    }

    public void updateVersionAndAnnounce() {
        this.updateVersion();
        MigrationManager.passiveAnnounce(this.version);
    }

    public synchronized void clear() {
        for (String keyspaceName : this.getNonSystemKeyspaces()) {
            KSMetaData ksm = this.getKSMetaData(keyspaceName);
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                this.purge(cfm);
            }
            this.clearKeyspaceDefinition(ksm);
        }
        this.updateVersionAndAnnounce();
    }

    public void addKeyspace(KSMetaData ksm) {
        assert (this.getKSMetaData(ksm.name) == null);
        this.load(ksm);
        Keyspace.open(ksm.name);
        MigrationManager.instance.notifyCreateKeyspace(ksm);
    }

    public void updateKeyspace(String ksName) {
        KSMetaData oldKsm = this.getKSMetaData(ksName);
        assert (oldKsm != null);
        KSMetaData newKsm = LegacySchemaTables.createKeyspaceFromName(ksName).cloneWith(oldKsm.cfMetaData().values(), oldKsm.userTypes);
        this.setKeyspaceDefinition(newKsm);
        Keyspace.open(ksName).createReplicationStrategy(newKsm);
        MigrationManager.instance.notifyUpdateKeyspace(newKsm);
    }

    public void dropKeyspace(String ksName) {
        KSMetaData ksm = instance.getKSMetaData(ksName);
        String snapshotName = Keyspace.getTimestampedSnapshotName(ksName);
        CompactionManager.instance.interruptCompactionFor(ksm.cfMetaData().values(), true);
        Keyspace keyspace = Keyspace.open(ksm.name);
        ArrayList<UUID> droppedCfs = new ArrayList<UUID>();
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(cfm.cfName);
            this.purge(cfm);
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(snapshotName);
            }
            Keyspace.open(ksm.name).dropCf(cfm.cfId);
            droppedCfs.add(cfm.cfId);
        }
        Keyspace.clear(ksm.name);
        this.clearKeyspaceDefinition(ksm);
        keyspace.writeOrder.awaitNewBarrier();
        CommitLog.instance.forceRecycleAllSegments(droppedCfs);
        MigrationManager.instance.notifyDropKeyspace(ksm);
    }

    public void addTable(CFMetaData cfm) {
        assert (this.getCFMetaData(cfm.ksName, cfm.cfName) == null);
        KSMetaData ksm = this.getKSMetaData(cfm.ksName).cloneWithTableAdded(cfm);
        logger.info("Loading {}", (Object)cfm);
        this.load(cfm);
        Keyspace.open(cfm.ksName);
        this.setKeyspaceDefinition(ksm);
        Keyspace.open(ksm.name).initCf(cfm.cfId, cfm.cfName, true);
        MigrationManager.instance.notifyCreateColumnFamily(cfm);
    }

    public void updateTable(String ksName, String tableName) {
        CFMetaData cfm = this.getCFMetaData(ksName, tableName);
        assert (cfm != null);
        boolean columnsDidChange = cfm.reload();
        Keyspace keyspace = Keyspace.open(cfm.ksName);
        keyspace.getColumnFamilyStore(cfm.cfName).reload();
        MigrationManager.instance.notifyUpdateColumnFamily(cfm, columnsDidChange);
    }

    public void dropTable(String ksName, String tableName) {
        KSMetaData ksm = this.getKSMetaData(ksName);
        assert (ksm != null);
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(tableName);
        assert (cfs != null);
        CFMetaData cfm = ksm.cfMetaData().get(tableName);
        this.purge(cfm);
        this.setKeyspaceDefinition(ksm.cloneWithTableRemoved(cfm));
        CompactionManager.instance.interruptCompactionFor(Arrays.asList(cfm), true);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            cfs.snapshot(Keyspace.getTimestampedSnapshotName(cfs.name));
        }
        Keyspace.open(ksm.name).dropCf(cfm.cfId);
        MigrationManager.instance.notifyDropColumnFamily(cfm);
        CommitLog.instance.forceRecycleAllSegments(Collections.singleton(cfm.cfId));
    }

    public void addType(UserType ut) {
        KSMetaData ksm = this.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        logger.info("Loading {}", (Object)ut);
        ksm.userTypes.addType(ut);
        MigrationManager.instance.notifyCreateUserType(ut);
    }

    public void updateType(UserType ut) {
        KSMetaData ksm = this.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        logger.info("Updating {}", (Object)ut);
        ksm.userTypes.addType(ut);
        MigrationManager.instance.notifyUpdateUserType(ut);
    }

    public void dropType(UserType ut) {
        KSMetaData ksm = this.getKSMetaData(ut.keyspace);
        assert (ksm != null);
        ksm.userTypes.removeType(ut);
        MigrationManager.instance.notifyDropUserType(ut);
    }

    public void addFunction(UDFunction udf) {
        logger.info("Loading {}", (Object)udf);
        Functions.addFunction(udf);
        MigrationManager.instance.notifyCreateFunction(udf);
    }

    public void updateFunction(UDFunction udf) {
        logger.info("Updating {}", (Object)udf);
        Functions.replaceFunction(udf);
        MigrationManager.instance.notifyUpdateFunction(udf);
    }

    public void dropFunction(UDFunction udf) {
        logger.info("Drop {}", (Object)udf);
        Functions.removeFunction(udf.name(), udf.argTypes());
        MigrationManager.instance.notifyDropFunction(udf);
    }

    public void addAggregate(UDAggregate udf) {
        logger.info("Loading {}", (Object)udf);
        Functions.addFunction(udf);
        MigrationManager.instance.notifyCreateAggregate(udf);
    }

    public void updateAggregate(UDAggregate udf) {
        logger.info("Updating {}", (Object)udf);
        Functions.replaceFunction(udf);
        MigrationManager.instance.notifyUpdateAggregate(udf);
    }

    public void dropAggregate(UDAggregate udf) {
        logger.info("Drop {}", (Object)udf);
        Functions.removeFunction(udf.name(), udf.argTypes());
        MigrationManager.instance.notifyDropAggregate(udf);
    }

    static {
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

