/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;

public final class Refs<T extends RefCounted>
extends AbstractCollection<T>
implements AutoCloseable {
    private final Map<T, Ref> references;

    public Refs() {
        this.references = new HashMap<T, Ref>();
    }

    public Refs(Map<T, Ref> references) {
        this.references = new HashMap<T, Ref>(references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            Refs.release(this.references.values());
        }
        finally {
            this.references.clear();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    public Ref get(T referenced) {
        return this.references.get(referenced);
    }

    public void release(T referenced) {
        Ref ref = this.references.remove(referenced);
        if (ref == null) {
            throw new IllegalStateException("This Refs collection does not hold a reference to " + referenced);
        }
        ref.release();
    }

    public boolean releaseIfHolds(T referenced) {
        Ref ref = this.references.remove(referenced);
        if (ref != null) {
            ref.release();
        }
        return ref != null;
    }

    public void release(Collection<T> release) {
        IllegalStateException notPresentFail;
        block7: {
            ArrayList<Ref> refs = new ArrayList<Ref>();
            ArrayList<RefCounted> notPresent = null;
            for (RefCounted obj : release) {
                Ref ref = this.references.remove(obj);
                if (ref == null) {
                    if (notPresent == null) {
                        notPresent = new ArrayList<RefCounted>();
                    }
                    notPresent.add(obj);
                    continue;
                }
                refs.add(ref);
            }
            notPresentFail = null;
            if (notPresent != null) {
                notPresentFail = new IllegalStateException("Could not release references to " + notPresent + " as references to these objects were not held");
                notPresentFail.fillInStackTrace();
            }
            try {
                Refs.release(refs);
            }
            catch (Throwable t) {
                if (notPresentFail == null) break block7;
                t.addSuppressed(notPresentFail);
            }
        }
        if (notPresentFail != null) {
            throw notPresentFail;
        }
    }

    public boolean tryRef(T t) {
        Ref ref = t.tryRef();
        if (ref == null) {
            return false;
        }
        if ((ref = this.references.put(t, ref)) != null) {
            ref.release();
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.references.keySet().iterator());
    }

    @Override
    public int size() {
        return this.references.size();
    }

    public Refs<T> addAll(Refs<T> add) {
        ArrayList<Ref> overlap = new ArrayList<Ref>();
        for (Map.Entry<T, Ref> e : add.references.entrySet()) {
            if (this.references.containsKey(e.getKey())) {
                overlap.add(e.getValue());
                continue;
            }
            this.references.put(e.getKey(), e.getValue());
        }
        add.references.clear();
        Refs.release(overlap);
        return this;
    }

    public static <T extends RefCounted> Refs<T> tryRef(Iterable<T> reference) {
        HashMap<RefCounted, Ref> refs = new HashMap<RefCounted, Ref>();
        for (RefCounted rc : reference) {
            Ref ref = rc.tryRef();
            if (ref == null) {
                Refs.release(refs.values());
                return null;
            }
            refs.put(rc, ref);
        }
        return new Refs(refs);
    }

    public static <T extends RefCounted> Refs<T> ref(Iterable<T> reference) {
        Refs<T> refs = Refs.tryRef(reference);
        if (refs != null) {
            return refs;
        }
        throw new IllegalStateException();
    }

    private static void release(Iterable<Ref> refs) {
        Throwable fail = null;
        for (Ref ref : refs) {
            try {
                ref.release();
            }
            catch (Throwable t) {
                if (fail == null) {
                    fail = t;
                    continue;
                }
                fail.addSuppressed(t);
            }
        }
        if (fail != null) {
            throw Throwables.propagate(fail);
        }
    }
}

