/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;

final class RefCountedImpl
implements RefCounted {
    private final Ref sharedRef;
    private final GlobalState state;
    private static final Set<GlobalState> globallyExtant = Collections.newSetFromMap(new ConcurrentHashMap());
    static final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    private static final ExecutorService EXEC = Executors.newFixedThreadPool(1, new NamedThreadFactory("Reference-Reaper"));

    public RefCountedImpl(RefCounted.Tidy tidy) {
        this.state = new GlobalState(tidy);
        this.sharedRef = new Ref(this.state, true);
        globallyExtant.add(this.state);
    }

    @Override
    public Ref tryRef() {
        return this.state.ref() ? new Ref(this.state, false) : null;
    }

    @Override
    public Ref sharedRef() {
        return this.sharedRef;
    }

    static {
        EXEC.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        while (true) {
                            Reference<Object> obj;
                            if (!((obj = referenceQueue.remove()) instanceof Ref.State)) {
                                continue;
                            }
                            ((Ref.State)obj).release(true);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        EXEC.execute(this);
                    }
                }
                catch (Throwable throwable) {
                    EXEC.execute(this);
                    throw throwable;
                }
            }
        });
    }

    static final class GlobalState {
        private final ConcurrentLinkedQueue<Ref.State> locallyExtant = new ConcurrentLinkedQueue();
        private final AtomicInteger counts = new AtomicInteger();
        private final RefCounted.Tidy tidy;

        GlobalState(RefCounted.Tidy tidy) {
            this.tidy = tidy;
        }

        void register(Ref.State ref) {
            this.locallyExtant.add(ref);
        }

        boolean ref() {
            int cur;
            do {
                if ((cur = this.counts.get()) >= 0) continue;
                return false;
            } while (!this.counts.compareAndSet(cur, cur + 1));
            return true;
        }

        void release(Ref.State ref) {
            this.locallyExtant.remove(ref);
            if (-1 == this.counts.decrementAndGet()) {
                globallyExtant.remove(this);
                this.tidy.tidy();
            }
        }

        int count() {
            return 1 + this.counts.get();
        }

        public String toString() {
            return this.tidy.name();
        }
    }
}

