/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.AbstractIterator;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.Checksum;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.IAllocator;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBUtilities {
    private static final Logger logger = LoggerFactory.getLogger(FBUtilities.class);
    private static ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
    public static final BigInteger TWO = new BigInteger("2");
    private static final String DEFAULT_TRIGGER_DIR = "triggers";
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_WINDOWS = OPERATING_SYSTEM.contains("windows");
    private static final boolean HAS_PROCFS = !IS_WINDOWS && new File(File.separator + "proc").exists();
    private static volatile InetAddress localInetAddress;
    private static volatile InetAddress broadcastInetAddress;
    private static final ThreadLocal<MessageDigest> localMD5Digest;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public static int getAvailableProcessors() {
        if (System.getProperty("cassandra.available_processors") != null) {
            return Integer.parseInt(System.getProperty("cassandra.available_processors"));
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static MessageDigest threadLocalMD5Digest() {
        return localMD5Digest.get();
    }

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress == null) {
            try {
                localInetAddress = DatabaseDescriptor.getListenAddress() == null ? InetAddress.getLocalHost() : DatabaseDescriptor.getListenAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress;
    }

    public static InetAddress getBroadcastAddress() {
        if (broadcastInetAddress == null) {
            broadcastInetAddress = DatabaseDescriptor.getBroadcastAddress() == null ? FBUtilities.getLocalAddress() : DatabaseDescriptor.getBroadcastAddress();
        }
        return broadcastInetAddress;
    }

    public static Collection<InetAddress> getAllLocalAddresses() {
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            if (nets != null) {
                while (nets.hasMoreElements()) {
                    localAddresses.addAll(Collections.list(nets.nextElement().getInetAddresses()));
                }
            }
        }
        catch (SocketException e) {
            throw new AssertionError((Object)e);
        }
        return localAddresses;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return Pair.create(midpoint, remainder);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2, int offset1, int offset2, int len1, int len2) {
        return FastByteOperations.compareUnsigned(bytes1, offset1, len1, bytes2, offset2, len2);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2) {
        return FBUtilities.compareUnsigned(bytes1, bytes2, 0, 0, bytes1.length, bytes2.length);
    }

    public static byte[] xor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.length > right.length) {
            byte[] swap = left;
            left = right;
            right = swap;
        }
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    public static byte[] hash(ByteBuffer ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (ByteBuffer block : data) {
            if (block.hasArray()) {
                messageDigest.update(block.array(), block.arrayOffset() + block.position(), block.remaining());
                continue;
            }
            messageDigest.update(block.duplicate());
        }
        return messageDigest.digest();
    }

    public static BigInteger hashToBigInteger(ByteBuffer data) {
        return new BigInteger(FBUtilities.hash(data)).abs();
    }

    @Deprecated
    public static void serialize(TSerializer serializer, TBase struct, DataOutput out) throws IOException {
        byte[] bytes;
        assert (serializer != null);
        assert (struct != null);
        assert (out != null);
        try {
            bytes = serializer.serialize(struct);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Deprecated
    public static void deserialize(TDeserializer deserializer, TBase struct, DataInput in) throws IOException {
        assert (deserializer != null);
        assert (struct != null);
        assert (in != null);
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        try {
            deserializer.deserialize(struct, bytes);
        }
        catch (TException ex) {
            throw new IOException(ex);
        }
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range<Token> range) {
        if (((Token)range.left).compareTo(range.right) >= 0) {
            final Token right = (Token)range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.getToken()) < 0 && right.compareTo(o2.getToken()) < 0 || right.compareTo(o1.getToken()) > 0 && right.compareTo(o2.getToken()) > 0) {
                        return o1.compareTo(o2);
                    }
                    return o2.compareTo(o1);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static String resourceToFile(String filename) throws ConfigurationException {
        ClassLoader loader = FBUtilities.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new ConfigurationException("unable to locate " + filename);
        }
        return new File(scpurl.getFile()).getAbsolutePath();
    }

    public static File cassandraTriggerDir() {
        File triggerDir = null;
        if (System.getProperty("cassandra.triggers_dir") != null) {
            triggerDir = new File(System.getProperty("cassandra.triggers_dir"));
        } else {
            URL confDir = FBUtilities.class.getClassLoader().getResource(DEFAULT_TRIGGER_DIR);
            if (confDir != null) {
                triggerDir = new File(confDir.getFile());
            }
        }
        if (triggerDir == null || !triggerDir.exists()) {
            logger.warn("Trigger directory doesn't exist, please create it and try again.");
            return null;
        }
        return triggerDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getReleaseVersionString() {
        String string;
        InputStream in;
        block5: {
            in = null;
            in = FBUtilities.class.getClassLoader().getResourceAsStream("org/apache/cassandra/config/version.properties");
            if (in != null) break block5;
            String string2 = System.getProperty("cassandra.releaseVersion", "Unknown");
            FileUtils.closeQuietly(in);
            return string2;
        }
        try {
            Properties props = new Properties();
            props.load(in);
            string = props.getProperty("CassandraVersion");
        }
        catch (Exception e) {
            String string3;
            try {
                JVMStabilityInspector.inspectThrowable(e);
                logger.warn("Unable to load version.properties", (Throwable)e);
                string3 = "debug version";
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(in);
                throw throwable;
            }
            FileUtils.closeQuietly(in);
            return string3;
        }
        FileUtils.closeQuietly(in);
        return string;
    }

    public static long timestampMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static void waitOnFutures(Iterable<Future<?>> futures) {
        for (Future<?> f : futures) {
            FBUtilities.waitOnFuture(f);
        }
    }

    public static <T> T waitOnFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ie) {
            throw new AssertionError((Object)ie);
        }
    }

    public static void waitOnFutures(List<AsyncOneResponse> results, long ms) throws TimeoutException {
        for (AsyncOneResponse result : results) {
            result.get(ms, TimeUnit.MILLISECONDS);
        }
    }

    public static IPartitioner newPartitioner(String partitionerClassName) throws ConfigurationException {
        if (!partitionerClassName.contains(".")) {
            partitionerClassName = "org.apache.cassandra.dht." + partitionerClassName;
        }
        return (IPartitioner)FBUtilities.construct(partitionerClassName, "partitioner");
    }

    public static IAllocator newOffHeapAllocator(String offheap_allocator) throws ConfigurationException {
        if (!offheap_allocator.contains(".")) {
            offheap_allocator = "org.apache.cassandra.io.util." + offheap_allocator;
        }
        return (IAllocator)FBUtilities.construct(offheap_allocator, "off-heap allocator");
    }

    public static IAuthorizer newAuthorizer(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthorizer)FBUtilities.construct(className, "authorizer");
    }

    public static IAuthenticator newAuthenticator(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthenticator)FBUtilities.construct(className, "authenticator");
    }

    public static <T> Class<T> classForName(String classname, String readable) throws ConfigurationException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname), e);
        }
        catch (NoClassDefFoundError e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname), e);
        }
    }

    public static <T> T construct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Default constructor for %s class '%s' is inaccessible.", readable, classname));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Cannot use abstract class '%s' as %s.", classname, readable));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException(String.format("Error instantiating %s class '%s'.", readable, classname), e);
        }
    }

    public static <T> SortedSet<T> singleton(T column, Comparator<? super T> comparator) {
        TreeSet<T> s = new TreeSet<T>(comparator);
        s.add(column);
        return s;
    }

    public static String toString(Map<?, ?> map) {
        Joiner.MapJoiner joiner = Joiner.on((String)", ").withKeyValueSeparator(":");
        return joiner.join(map);
    }

    public static Field getProtectedField(Class klass, String fieldName) {
        Field field;
        try {
            field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return field;
    }

    public static <T> CloseableIterator<T> closeableIterator(Iterator<T> iterator) {
        return new WrappedCloseableIterator<T>(iterator);
    }

    public static Map<String, String> fromJsonMap(String json) {
        try {
            return (Map)jsonMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> fromJsonList(String json) {
        try {
            return (List)jsonMapper.readValue(json, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String json(Object object) {
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void exec(ProcessBuilder pb) throws IOException {
        Process p = pb.start();
        try {
            int errCode = p.waitFor();
            if (errCode != 0) {
                String str;
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                StringBuilder sb = new StringBuilder();
                while ((str = in.readLine()) != null) {
                    sb.append(str).append(System.getProperty("line.separator"));
                }
                while ((str = err.readLine()) != null) {
                    sb.append(str).append(System.getProperty("line.separator"));
                }
                throw new IOException("Exception while executing the command: " + StringUtils.join(pb.command(), (String)" ") + ", command error Code: " + errCode + ", command output: " + sb.toString());
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void updateChecksumInt(Checksum checksum, int v) {
        checksum.update(v >>> 24 & 0xFF);
        checksum.update(v >>> 16 & 0xFF);
        checksum.update(v >>> 8 & 0xFF);
        checksum.update(v >>> 0 & 0xFF);
    }

    public static long abs(long index) {
        long negbit = index >> 63;
        return (index ^ negbit) - negbit;
    }

    public static <T> byte[] serialize(T object, IVersionedSerializer<T> serializer, int version) {
        try {
            int size = (int)serializer.serializedSize(object, version);
            DataOutputBuffer buffer = new DataOutputBuffer(size);
            serializer.serialize(object, buffer, version);
            assert (buffer.getLength() == size && buffer.getData().length == size) : String.format("Final buffer length %s to accommodate data size of %s (predicted %s) for %s", buffer.getData().length, buffer.getLength(), size, object);
            return buffer.getData();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long copy(InputStream from, OutputStream to, long limit) throws IOException {
        int sofar;
        byte[] buffer = new byte[64];
        long copied = 0L;
        int toCopy = buffer.length;
        do {
            if (limit < (long)buffer.length + copied) {
                toCopy = (int)(limit - copied);
            }
            if ((sofar = from.read(buffer, 0, toCopy)) == -1) break;
            to.write(buffer, 0, sofar);
        } while (limit != (copied += (long)sofar));
        return copied;
    }

    public static File getToolsOutputDirectory() {
        File historyDir = new File(System.getProperty("user.home"), ".cassandra");
        FileUtils.createDirectory(historyDir);
        return historyDir;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean hasProcFS() {
        return HAS_PROCFS;
    }

    public static void updateWithShort(MessageDigest digest, int val) {
        digest.update((byte)(val >> 8 & 0xFF));
        digest.update((byte)(val & 0xFF));
    }

    public static void updateWithByte(MessageDigest digest, int val) {
        digest.update((byte)(val & 0xFF));
    }

    public static void updateWithInt(MessageDigest digest, int val) {
        digest.update((byte)(val >>> 24 & 0xFF));
        digest.update((byte)(val >>> 16 & 0xFF));
        digest.update((byte)(val >>> 8 & 0xFF));
        digest.update((byte)(val >>> 0 & 0xFF));
    }

    public static void updateWithLong(MessageDigest digest, long val) {
        digest.update((byte)(val >>> 56 & 0xFFL));
        digest.update((byte)(val >>> 48 & 0xFFL));
        digest.update((byte)(val >>> 40 & 0xFFL));
        digest.update((byte)(val >>> 32 & 0xFFL));
        digest.update((byte)(val >>> 24 & 0xFFL));
        digest.update((byte)(val >>> 16 & 0xFFL));
        digest.update((byte)(val >>> 8 & 0xFFL));
        digest.update((byte)(val >>> 0 & 0xFFL));
    }

    static {
        localMD5Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                return FBUtilities.newMessageDigest("MD5");
            }

            @Override
            public MessageDigest get() {
                MessageDigest digest = (MessageDigest)super.get();
                digest.reset();
                return digest;
            }
        };
    }

    private static final class WrappedCloseableIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> source;

        public WrappedCloseableIterator(Iterator<T> source) {
            this.source = source;
        }

        protected T computeNext() {
            if (!this.source.hasNext()) {
                return (T)this.endOfData();
            }
            return this.source.next();
        }

        @Override
        public void close() {
        }
    }
}

