/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.MappedFileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmappedSegmentedFile
extends SegmentedFile {
    private static final Logger logger = LoggerFactory.getLogger(MmappedSegmentedFile.class);
    public static long MAX_SEGMENT_SIZE = Integer.MAX_VALUE;
    private final SegmentedFile.Segment[] segments;

    public MmappedSegmentedFile(String path, long length, SegmentedFile.Segment[] segments) {
        super(path, length);
        this.segments = segments;
    }

    private SegmentedFile.Segment floor(long position) {
        assert (0L <= position && position < this.length) : String.format("%d >= %d in %s", position, this.length, this.path);
        SegmentedFile.Segment seg = new SegmentedFile.Segment(position, null);
        int idx = Arrays.binarySearch(this.segments, seg);
        assert (idx != -1) : String.format("Bad position %d for segments %s in %s", position, Arrays.toString(this.segments), this.path);
        if (idx < 0) {
            idx = -(idx + 2);
        }
        return this.segments[idx];
    }

    @Override
    public FileDataInput getSegment(long position) {
        SegmentedFile.Segment segment = this.floor(position);
        if (segment.right != null) {
            return new MappedFileDataInput((MappedByteBuffer)segment.right, this.path, (long)((Long)segment.left), (int)(position - (Long)segment.left));
        }
        RandomAccessReader file = RandomAccessReader.open(new File(this.path));
        file.seek(position);
        return file;
    }

    @Override
    public void cleanup() {
        if (!FileUtils.isCleanerAvailable()) {
            return;
        }
        try {
            for (SegmentedFile.Segment segment : this.segments) {
                if (segment.right == null) continue;
                FileUtils.clean((MappedByteBuffer)segment.right);
            }
            logger.debug("All segments have been unmapped successfully");
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            logger.error("Error while unmapping segments", (Throwable)e);
        }
    }

    static class Builder
    extends SegmentedFile.Builder {
        private List<Long> boundaries = new ArrayList<Long>();
        private long currentStart = 0L;
        private long currentSize = 0L;

        public Builder() {
            this.boundaries.add(0L);
        }

        @Override
        public void addPotentialBoundary(long boundary) {
            if (boundary - this.currentStart <= MAX_SEGMENT_SIZE) {
                this.currentSize = boundary - this.currentStart;
                return;
            }
            if (this.currentSize > 0L) {
                this.currentStart += this.currentSize;
                this.boundaries.add(this.currentStart);
            }
            this.currentSize = boundary - this.currentStart;
            if (this.currentSize > MAX_SEGMENT_SIZE) {
                this.currentStart = boundary;
                this.boundaries.add(this.currentStart);
                this.currentSize = 0L;
            }
        }

        @Override
        public SegmentedFile complete(String path, SSTableWriter.FinishType finishType) {
            long length = new File(path).length();
            return new MmappedSegmentedFile(path, length, this.createSegments(path));
        }

        private SegmentedFile.Segment[] createSegments(String path) {
            long length;
            RandomAccessFile raf;
            try {
                raf = new RandomAccessFile(path, "r");
                length = raf.length();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ArrayList<Long> boundaries = new ArrayList<Long>(this.boundaries);
            if (length != (Long)boundaries.get(boundaries.size() - 1)) {
                boundaries.add(length);
            }
            int segcount = boundaries.size() - 1;
            SegmentedFile.Segment[] segments = new SegmentedFile.Segment[segcount];
            try {
                for (int i = 0; i < segcount; ++i) {
                    long start = (Long)boundaries.get(i);
                    long size = (Long)boundaries.get(i + 1) - start;
                    MappedByteBuffer segment = size <= MAX_SEGMENT_SIZE ? raf.getChannel().map(FileChannel.MapMode.READ_ONLY, start, size) : null;
                    segments[i] = new SegmentedFile.Segment(start, segment);
                }
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, path);
            }
            finally {
                FileUtils.closeQuietly(raf);
            }
            return segments;
        }

        @Override
        public void serializeBounds(DataOutput out) throws IOException {
            super.serializeBounds(out);
            out.writeInt(this.boundaries.size());
            for (long position : this.boundaries) {
                out.writeLong(position);
            }
        }

        @Override
        public void deserializeBounds(DataInput in) throws IOException {
            super.deserializeBounds(in);
            int size = in.readInt();
            ArrayList<Long> temp = new ArrayList<Long>(size);
            for (int i = 0; i < size; ++i) {
                temp.add(in.readLong());
            }
            this.boundaries = temp;
        }
    }
}

