/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.SegmentedFile;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    @Override
    public FileDataInput getSegment(long position) {
        CompressedRandomAccessReader reader = CompressedRandomAccessReader.open(this.path, this.metadata, null);
        reader.seek(position);
        return reader;
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void cleanup() {
        this.metadata.close();
    }

    public static class Builder
    extends SegmentedFile.Builder {
        protected final CompressedSequentialWriter writer;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        protected CompressionMetadata metadata(String path, SSTableWriter.FinishType finishType) {
            if (this.writer == null) {
                return CompressionMetadata.create(path);
            }
            return this.writer.open(finishType);
        }

        @Override
        public SegmentedFile complete(String path, SSTableWriter.FinishType finishType) {
            return new CompressedSegmentedFile(path, this.metadata(path, finishType));
        }
    }
}

