/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.CompressedSegmentedFile;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;

public class CompressedPoolingSegmentedFile
extends PoolingSegmentedFile
implements ICompressedFile {
    public final CompressionMetadata metadata;

    public CompressedPoolingSegmentedFile(String path, CompressionMetadata metadata) {
        super(path, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
    }

    @Override
    protected RandomAccessReader createReader(String path) {
        return CompressedRandomAccessReader.open(path, this.metadata, this);
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.metadata.close();
    }

    public static class Builder
    extends CompressedSegmentedFile.Builder {
        public Builder(CompressedSequentialWriter writer) {
            super(writer);
        }

        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path, SSTableWriter.FinishType finishType) {
            return new CompressedPoolingSegmentedFile(path, this.metadata(path, finishType));
        }
    }
}

