/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.FBUtilities;

public class SSTableRewriter {
    private static long preemptiveOpenInterval;
    private final DataTracker dataTracker;
    private final ColumnFamilyStore cfs;
    private final long maxAge;
    private final List<SSTableReader> finished = new ArrayList<SSTableReader>();
    private final Set<SSTableReader> rewriting;
    private final Map<Descriptor, DecoratedKey> originalStarts = new HashMap<Descriptor, DecoratedKey>();
    private final Map<Descriptor, Integer> fileDescriptors = new HashMap<Descriptor, Integer>();
    private SSTableReader currentlyOpenedEarly;
    private long currentlyOpenedEarlyAt;
    private final Queue<Finished> finishedEarly = new ArrayDeque<Finished>();
    private final List<SSTableReader> discard = new ArrayList<SSTableReader>();
    private final boolean isOffline;
    private SSTableWriter writer;
    private Map<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();

    @VisibleForTesting
    static void overrideOpenInterval(long size) {
        preemptiveOpenInterval = size;
    }

    public SSTableRewriter(ColumnFamilyStore cfs, Set<SSTableReader> rewriting, long maxAge, boolean isOffline) {
        this.rewriting = rewriting;
        for (SSTableReader sstable : rewriting) {
            this.originalStarts.put(sstable.descriptor, sstable.first);
            this.fileDescriptors.put(sstable.descriptor, CLibrary.getfd(sstable.getFilename()));
        }
        this.dataTracker = cfs.getDataTracker();
        this.cfs = cfs;
        this.maxAge = maxAge;
        this.isOffline = isOffline;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        this.maybeReopenEarly(row.key);
        RowIndexEntry index = this.writer.append(row);
        if (!this.isOffline) {
            if (index == null) {
                this.cfs.invalidateCachedRow(row.key);
            } else {
                boolean save = false;
                for (SSTableReader reader : this.rewriting) {
                    if (reader.getCachedPosition(row.key, false) == null) continue;
                    save = true;
                    break;
                }
                if (save) {
                    this.cachedKeys.put(row.key, index);
                }
            }
        }
        return index;
    }

    public RowIndexEntry tryAppend(AbstractCompactedRow row) {
        this.writer.mark();
        try {
            return this.append(row);
        }
        catch (Throwable t) {
            this.writer.resetAndTruncate();
            throw t;
        }
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (!FBUtilities.isWindows() && this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > preemptiveOpenInterval) {
            if (this.isOffline) {
                for (SSTableReader reader : this.rewriting) {
                    RowIndexEntry index = reader.getPosition(key, SSTableReader.Operator.GE);
                    CLibrary.trySkipCache((int)this.fileDescriptors.get(reader.descriptor), 0L, index == null ? 0L : index.position);
                }
            } else {
                SSTableReader reader = this.writer.openEarly(this.maxAge);
                if (reader != null) {
                    this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
                    this.currentlyOpenedEarly = reader;
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
                }
            }
        }
    }

    public void abort() {
        this.switchWriter(null, true);
        this.moveStarts(null, (Function<? super Descriptor, DecoratedKey>)Functions.forMap(this.originalStarts), true);
        for (SSTableReader sstable : this.finished) {
            sstable.markObsolete();
            sstable.sharedRef().release();
        }
        for (Finished finished : this.finishedEarly) {
            boolean opened = finished.reader != null;
            finished.writer.abort(!opened);
            if (!opened) continue;
            this.discard.add(finished.reader);
            finished.reader.markObsolete();
        }
        this.replaceWithFinishedReaders(Collections.emptyList());
    }

    private void moveStarts(SSTableReader newReader, Function<? super Descriptor, DecoratedKey> newStarts, boolean reset) {
        if (this.isOffline) {
            return;
        }
        ArrayList<SSTableReader> toReplace = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> replaceWith = new ArrayList<SSTableReader>();
        final ArrayList<DecoratedKey> invalidateKeys = new ArrayList<DecoratedKey>();
        if (!reset) {
            invalidateKeys.addAll(this.cachedKeys.keySet());
            for (Map.Entry entry : this.cachedKeys.entrySet()) {
                newReader.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        this.cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        for (final SSTableReader sSTableReader : this.rewriting) {
            DecoratedKey newStart = (DecoratedKey)newStarts.apply((Object)sSTableReader.descriptor);
            assert (newStart != null);
            if (sSTableReader.first.compareTo(newStart) >= 0 && (!reset || newStart == sSTableReader.first)) continue;
            toReplace.add(sSTableReader);
            replaceWith.add(sSTableReader.getCurrentReplacement().cloneWithNewStart(newStart, new Runnable(){

                @Override
                public void run() {
                    for (DecoratedKey key : invalidateKeys) {
                        sSTableReader.invalidateCacheKey(key);
                    }
                }
            }));
        }
        this.cfs.getDataTracker().replaceWithNewInstances(toReplace, replaceWith);
        this.rewriting.removeAll(toReplace);
        this.rewriting.addAll(replaceWith);
    }

    private void replaceEarlyOpenedFile(SSTableReader toReplace, SSTableReader replaceWith) {
        Set<SSTableReader> toReplaceSet;
        if (this.isOffline) {
            return;
        }
        if (toReplace != null) {
            toReplace.setReplacedBy(replaceWith);
            toReplaceSet = Collections.singleton(toReplace);
        } else {
            this.dataTracker.markCompacting(Collections.singleton(replaceWith));
            toReplaceSet = Collections.emptySet();
        }
        this.dataTracker.replaceEarlyOpenedFiles(toReplaceSet, Collections.singleton(replaceWith));
    }

    public void switchWriter(SSTableWriter newWriter) {
        this.switchWriter(newWriter, false);
    }

    private void switchWriter(SSTableWriter newWriter, boolean abort) {
        if (this.writer == null) {
            this.writer = newWriter;
            return;
        }
        if (this.writer.getFilePointer() != 0L && !abort) {
            SSTableReader reader = this.writer.finish(SSTableWriter.FinishType.EARLY, this.maxAge, -1L);
            this.replaceEarlyOpenedFile(this.currentlyOpenedEarly, reader);
            this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
            this.finishedEarly.add(new Finished(this.writer, reader));
        } else {
            this.writer.abort();
        }
        this.currentlyOpenedEarly = null;
        this.currentlyOpenedEarlyAt = 0L;
        this.writer = newWriter;
    }

    public List<SSTableReader> finish() {
        return this.finish(-1L);
    }

    public List<SSTableReader> finish(long repairedAt) {
        return this.finishAndMaybeThrow(repairedAt, false, false);
    }

    @VisibleForTesting
    void finishAndThrow(boolean throwEarly) {
        this.finishAndMaybeThrow(-1L, throwEarly, !throwEarly);
    }

    private List<SSTableReader> finishAndMaybeThrow(long repairedAt, boolean throwEarly, boolean throwLate) {
        ArrayList<SSTableReader> newReaders = new ArrayList<SSTableReader>();
        this.switchWriter(null, false);
        if (throwEarly) {
            throw new RuntimeException("exception thrown early in finish, for testing");
        }
        while (!this.finishedEarly.isEmpty()) {
            Finished f = this.finishedEarly.poll();
            if (f.writer.getFilePointer() > 0L) {
                if (f.reader != null) {
                    this.discard.add(f.reader);
                }
                SSTableReader newReader = f.writer.finish(SSTableWriter.FinishType.FINISH_EARLY, this.maxAge, repairedAt);
                if (f.reader != null) {
                    f.reader.setReplacedBy(newReader);
                }
                this.finished.add(newReader);
                newReaders.add(newReader);
                continue;
            }
            f.writer.abort(true);
            assert (f.reader == null);
        }
        if (throwLate) {
            throw new RuntimeException("exception thrown after all sstables finished, for testing");
        }
        this.replaceWithFinishedReaders(newReaders);
        return this.finished;
    }

    private void replaceWithFinishedReaders(List<SSTableReader> finished) {
        if (this.isOffline) {
            for (SSTableReader reader : this.discard) {
                if (reader.getCurrentReplacement() == null) {
                    reader.markObsolete();
                }
                reader.sharedRef().release();
            }
        } else {
            this.dataTracker.replaceEarlyOpenedFiles(this.discard, finished);
            this.dataTracker.unmarkCompacting(this.discard);
        }
        this.discard.clear();
    }

    static {
        long interval = (long)DatabaseDescriptor.getSSTablePreempiveOpenIntervalInMB() * 0x100000L;
        if (interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        preemptiveOpenInterval = interval;
    }

    private static final class Finished {
        final SSTableWriter writer;
        final SSTableReader reader;

        private Finished(SSTableWriter writer, SSTableReader reader) {
            this.writer = writer;
            this.reader = reader;
        }
    }
}

