/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.exceptions.ConfigurationException;

public final class DateTieredCompactionStrategyOptions {
    protected static final TimeUnit DEFAULT_TIMESTAMP_RESOLUTION = TimeUnit.MICROSECONDS;
    protected static final long DEFAULT_MAX_SSTABLE_AGE_DAYS = 365L;
    protected static final long DEFAULT_BASE_TIME_SECONDS = 60L;
    protected static final String TIMESTAMP_RESOLUTION_KEY = "timestamp_resolution";
    protected static final String MAX_SSTABLE_AGE_KEY = "max_sstable_age_days";
    protected static final String BASE_TIME_KEY = "base_time_seconds";
    protected final long maxSSTableAge;
    protected final long baseTime;

    public DateTieredCompactionStrategyOptions(Map<String, String> options) {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        TimeUnit timestampResolution = optionValue == null ? DEFAULT_TIMESTAMP_RESOLUTION : TimeUnit.valueOf(optionValue);
        optionValue = options.get(MAX_SSTABLE_AGE_KEY);
        this.maxSSTableAge = timestampResolution.convert(optionValue == null ? 365L : Long.parseLong(optionValue), TimeUnit.DAYS);
        optionValue = options.get(BASE_TIME_KEY);
        this.baseTime = timestampResolution.convert(optionValue == null ? 60L : Long.parseLong(optionValue), TimeUnit.SECONDS);
    }

    public DateTieredCompactionStrategyOptions() {
        this.maxSSTableAge = DEFAULT_TIMESTAMP_RESOLUTION.convert(365L, TimeUnit.DAYS);
        this.baseTime = DEFAULT_TIMESTAMP_RESOLUTION.convert(60L, TimeUnit.SECONDS);
    }

    public static Map<String, String> validateOptions(Map<String, String> options, Map<String, String> uncheckedOptions) throws ConfigurationException {
        String optionValue = options.get(TIMESTAMP_RESOLUTION_KEY);
        try {
            if (optionValue != null) {
                TimeUnit.valueOf(optionValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.format("timestamp_resolution %s is not valid", optionValue));
        }
        optionValue = options.get(MAX_SSTABLE_AGE_KEY);
        try {
            long maxSStableAge;
            long l = maxSStableAge = optionValue == null ? 365L : Long.parseLong(optionValue);
            if (maxSStableAge < 0L) {
                throw new ConfigurationException(String.format("%s must be non-negative: %d", MAX_SSTABLE_AGE_KEY, maxSStableAge));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, MAX_SSTABLE_AGE_KEY), e);
        }
        optionValue = options.get(BASE_TIME_KEY);
        try {
            long baseTime;
            long l = baseTime = optionValue == null ? 60L : Long.parseLong(optionValue);
            if (baseTime <= 0L) {
                throw new ConfigurationException(String.format("%s must be greater than 0, but was %d", BASE_TIME_KEY, baseTime));
            }
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(String.format("%s is not a parsable int (base10) for %s", optionValue, BASE_TIME_KEY), e);
        }
        uncheckedOptions.remove(MAX_SSTABLE_AGE_KEY);
        uncheckedOptions.remove(BASE_TIME_KEY);
        uncheckedOptions.remove(TIMESTAMP_RESOLUTION_KEY);
        return uncheckedOptions;
    }
}

