/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.service.QueryState;

public abstract class BatchQueryOptions {
    public static BatchQueryOptions DEFAULT = BatchQueryOptions.withoutPerStatementVariables(QueryOptions.DEFAULT);
    protected final QueryOptions wrapped;
    private final List<Object> queryOrIdList;

    protected BatchQueryOptions(QueryOptions wrapped, List<Object> queryOrIdList) {
        this.wrapped = wrapped;
        this.queryOrIdList = queryOrIdList;
    }

    public static BatchQueryOptions withoutPerStatementVariables(QueryOptions options) {
        return new WithoutPerStatementVariables(options, Collections.emptyList());
    }

    public static BatchQueryOptions withPerStatementVariables(QueryOptions options, List<List<ByteBuffer>> variables, List<Object> queryOrIdList) {
        return new WithPerStatementVariables(options, variables, queryOrIdList);
    }

    public abstract QueryOptions forStatement(int var1);

    public ConsistencyLevel getConsistency() {
        return this.wrapped.getConsistency();
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.wrapped.getSerialConsistency();
    }

    public List<Object> getQueryOrIdList() {
        return this.queryOrIdList;
    }

    public long getTimestamp(QueryState state) {
        return this.wrapped.getTimestamp(state);
    }

    private static class WithPerStatementVariables
    extends BatchQueryOptions {
        private final List<QueryOptions> perStatementOptions;

        private WithPerStatementVariables(QueryOptions wrapped, List<List<ByteBuffer>> variables, List<Object> queryOrIdList) {
            super(wrapped, queryOrIdList);
            this.perStatementOptions = new ArrayList<QueryOptions>(variables.size());
            for (final List<ByteBuffer> vars : variables) {
                this.perStatementOptions.add(new QueryOptions.QueryOptionsWrapper(wrapped){

                    @Override
                    public List<ByteBuffer> getValues() {
                        return vars;
                    }
                });
            }
        }

        @Override
        public QueryOptions forStatement(int i) {
            return this.perStatementOptions.get(i);
        }
    }

    private static class WithoutPerStatementVariables
    extends BatchQueryOptions {
        private WithoutPerStatementVariables(QueryOptions wrapped, List<Object> queryOrIdList) {
            super(wrapped, queryOrIdList);
        }

        @Override
        public QueryOptions forStatement(int i) {
            return this.wrapped;
        }
    }
}

