/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.IndexName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;
    public final boolean ifExists;
    private String indexedCF;

    public DropIndexStatement(IndexName indexName, boolean ifExists) {
        super(indexName.getCfName());
        this.indexName = indexName.getIdx();
        this.ifExists = ifExists;
    }

    @Override
    public String columnFamily() {
        if (this.indexedCF != null) {
            return this.indexedCF;
        }
        try {
            CFMetaData cfm = this.findIndexedCF();
            return cfm == null ? null : cfm.cfName;
        }
        catch (InvalidRequestException ire) {
            throw new RuntimeException(ire);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData cfm = this.findIndexedCF();
        if (cfm == null) {
            return;
        }
        state.hasColumnFamilyAccess(cfm.ksName, cfm.cfName, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        this.announceMigration(false);
        return this.indexedCF == null ? null : new ResultMessage.SchemaChange(this.changeEvent());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm = this.findIndexedCF();
        if (cfm == null) {
            return false;
        }
        CFMetaData updatedCfm = this.updateCFMetadata(cfm);
        this.indexedCF = updatedCfm.cfName;
        MigrationManager.announceColumnFamilyUpdate(updatedCfm, false, isLocalOnly);
        return true;
    }

    private CFMetaData updateCFMetadata(CFMetaData cfm) {
        ColumnDefinition column = this.findIndexedColumn(cfm);
        assert (column != null);
        CFMetaData cloned = cfm.copy();
        ColumnDefinition toChange = cloned.getColumnDefinition(column.name);
        assert (toChange.getIndexName() != null && toChange.getIndexName().equals(this.indexName));
        toChange.setIndexName(null);
        toChange.setIndexType(null, null);
        return cloned;
    }

    private CFMetaData findIndexedCF() throws InvalidRequestException {
        KSMetaData ksm = Schema.instance.getKSMetaData(this.keyspace());
        if (ksm == null) {
            throw new KeyspaceNotDefinedException("Keyspace " + this.keyspace() + " does not exist");
        }
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (this.findIndexedColumn(cfm) == null) continue;
            return cfm;
        }
        if (this.ifExists) {
            return null;
        }
        throw new InvalidRequestException("Index '" + this.indexName + "' could not be found in any of the tables of keyspace '" + this.keyspace() + '\'');
    }

    private ColumnDefinition findIndexedColumn(CFMetaData cfm) {
        for (ColumnDefinition column : cfm.allColumns()) {
            if (column.getIndexType() == null || column.getIndexName() == null || !column.getIndexName().equals(this.indexName)) continue;
            return column;
        }
        return null;
    }
}

