/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.sstable.SSTableDeletingTask;
import org.apache.cassandra.service.GCInspectorMXBean;
import org.apache.cassandra.utils.StatusLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCInspector
implements NotificationListener,
GCInspectorMXBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.service:type=GCInspector";
    private static final Logger logger = LoggerFactory.getLogger(GCInspector.class);
    static final long MIN_LOG_DURATION = 200L;
    static final long GC_WARN_THRESHOLD_IN_MS = DatabaseDescriptor.getGCWarnThreshold();
    static final long STAT_THRESHOLD = Math.min(GC_WARN_THRESHOLD_IN_MS != 0L ? GC_WARN_THRESHOLD_IN_MS : 200L, 200L);
    final AtomicReference<State> state = new AtomicReference<State>(new State());
    final Map<String, GCState> gcStates = new HashMap<String, GCState>();

    public GCInspector() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
            for (ObjectName name : mbs.queryNames(gcName, null)) {
                GarbageCollectorMXBean gc = ManagementFactory.newPlatformMXBeanProxy(mbs, name.getCanonicalName(), GarbageCollectorMXBean.class);
                this.gcStates.put(gc.getName(), new GCState(gc, GCInspector.assumeGCIsPartiallyConcurrent(gc), GCInspector.assumeGCIsOldGen(gc)));
            }
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void register() throws Exception {
        GCInspector inspector = new GCInspector();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
        for (ObjectName name : server.queryNames(gcName, null)) {
            server.addNotificationListener(name, inspector, null, null);
        }
    }

    private static boolean assumeGCIsPartiallyConcurrent(GarbageCollectorMXBean gc) {
        switch (gc.getName()) {
            case "Copy": 
            case "MarkSweepCompact": 
            case "PS MarkSweep": 
            case "PS Scavenge": 
            case "G1 Young Generation": 
            case "ParNew": {
                return false;
            }
            case "ConcurrentMarkSweep": 
            case "G1 Old Generation": {
                return true;
            }
        }
        return true;
    }

    private static boolean assumeGCIsOldGen(GarbageCollectorMXBean gc) {
        switch (gc.getName()) {
            case "Copy": 
            case "PS Scavenge": 
            case "G1 Young Generation": 
            case "ParNew": {
                return false;
            }
            case "MarkSweepCompact": 
            case "PS MarkSweep": 
            case "ConcurrentMarkSweep": 
            case "G1 Old Generation": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (type.equals("com.sun.management.gc.notification")) {
            State prev;
            CompositeData cd = (CompositeData)notification.getUserData();
            GarbageCollectionNotificationInfo info = GarbageCollectionNotificationInfo.from(cd);
            String gcName = info.getGcName();
            GcInfo gcInfo = info.getGcInfo();
            long duration = gcInfo.getDuration();
            GCState gcState = this.gcStates.get(gcName);
            if (gcState.assumeGCIsPartiallyConcurrent) {
                long total;
                long previousTotal = gcState.lastGcTotalDuration;
                gcState.lastGcTotalDuration = total = gcState.gcBean.getCollectionTime();
                duration = total - previousTotal;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(info.getGcName()).append(" GC in ").append(duration).append("ms.  ");
            long bytes = 0L;
            Map<String, MemoryUsage> beforeMemoryUsage = gcInfo.getMemoryUsageBeforeGc();
            Map<String, MemoryUsage> afterMemoryUsage = gcInfo.getMemoryUsageAfterGc();
            for (String key : gcState.keys(info)) {
                MemoryUsage before = beforeMemoryUsage.get(key);
                MemoryUsage after = afterMemoryUsage.get(key);
                if (after == null || after.getUsed() == before.getUsed()) continue;
                sb.append(key).append(": ").append(before.getUsed());
                sb.append(" -> ");
                sb.append(after.getUsed());
                if (!key.equals(gcState.keys[gcState.keys.length - 1])) {
                    sb.append("; ");
                }
                bytes += before.getUsed() - after.getUsed();
            }
            while (!this.state.compareAndSet(prev = this.state.get(), new State(duration, bytes, prev))) {
            }
            String st = sb.toString();
            if (GC_WARN_THRESHOLD_IN_MS != 0L && duration > GC_WARN_THRESHOLD_IN_MS) {
                logger.warn(st);
            } else if (duration > 200L) {
                logger.info(st);
            } else if (logger.isDebugEnabled()) {
                logger.debug(st);
            }
            if (duration > STAT_THRESHOLD) {
                StatusLogger.log();
            }
            if (gcState.assumeGCIsOldGen) {
                SSTableDeletingTask.rescheduleFailedTasks();
            }
        }
    }

    public State getTotalSinceLastCheck() {
        return this.state.getAndSet(new State());
    }

    @Override
    public double[] getAndResetStats() {
        State state = this.getTotalSinceLastCheck();
        double[] r = new double[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - state.startNanos), state.maxRealTimeElapsed, state.totalRealTimeElapsed, state.sumSquaresRealTimeElapsed, state.totalBytesReclaimed, state.count};
        return r;
    }

    static final class GCState {
        final GarbageCollectorMXBean gcBean;
        final boolean assumeGCIsPartiallyConcurrent;
        final boolean assumeGCIsOldGen;
        private String[] keys;
        long lastGcTotalDuration = 0L;

        GCState(GarbageCollectorMXBean gcBean, boolean assumeGCIsPartiallyConcurrent, boolean assumeGCIsOldGen) {
            this.gcBean = gcBean;
            this.assumeGCIsPartiallyConcurrent = assumeGCIsPartiallyConcurrent;
            this.assumeGCIsOldGen = assumeGCIsOldGen;
        }

        String[] keys(GarbageCollectionNotificationInfo info) {
            if (this.keys != null) {
                return this.keys;
            }
            this.keys = info.getGcInfo().getMemoryUsageBeforeGc().keySet().toArray(new String[0]);
            Arrays.sort(this.keys);
            return this.keys;
        }
    }

    static final class State {
        final double maxRealTimeElapsed;
        final double totalRealTimeElapsed;
        final double sumSquaresRealTimeElapsed;
        final double totalBytesReclaimed;
        final double count;
        final long startNanos;

        State(double extraElapsed, double extraBytes, State prev) {
            this.totalRealTimeElapsed = prev.totalRealTimeElapsed + extraElapsed;
            this.totalBytesReclaimed = prev.totalBytesReclaimed + extraBytes;
            this.sumSquaresRealTimeElapsed = prev.sumSquaresRealTimeElapsed + extraElapsed * extraElapsed;
            this.startNanos = prev.startNanos;
            this.count = prev.count + 1.0;
            this.maxRealTimeElapsed = Math.max(prev.maxRealTimeElapsed, extraElapsed);
        }

        State() {
            this.totalBytesReclaimed = 0.0;
            this.totalRealTimeElapsed = 0.0;
            this.sumSquaresRealTimeElapsed = 0.0;
            this.maxRealTimeElapsed = 0.0;
            this.count = 0.0;
            this.startNanos = System.nanoTime();
        }
    }
}

