/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.Restriction;
import org.apache.cassandra.cql3.statements.SingleColumnRestriction;
import org.apache.cassandra.exceptions.InvalidRequestException;

public interface MultiColumnRestriction
extends Restriction {

    public static class Slice
    extends SingleColumnRestriction.Slice
    implements MultiColumnRestriction {
        public Slice(boolean onToken) {
            super(onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public ByteBuffer bound(Bound b, QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException("Multicolumn slice restrictions do not support bound()");
        }

        public List<ByteBuffer> componentBounds(Bound b, QueryOptions options) throws InvalidRequestException {
            Term.Terminal terminal = this.bounds[b.idx].bind(options);
            if (terminal instanceof Tuples.Value) {
                return ((Tuples.Value)terminal).getElements();
            }
            return Collections.singletonList(terminal.get(options));
        }
    }

    public static class InWithMarker
    extends SingleColumnRestriction.InWithMarker
    implements IN {
        public InWithMarker(AbstractMarker marker) {
            super(marker);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(QueryOptions options) throws InvalidRequestException {
            Tuples.InMarker inMarker = (Tuples.InMarker)this.marker;
            Tuples.InValue inValue = inMarker.bind(options);
            if (inValue == null) {
                throw new InvalidRequestException("Invalid null value for IN restriction");
            }
            return inValue.getSplitValues();
        }
    }

    public static class InWithValues
    extends SingleColumnRestriction.InWithValues
    implements IN {
        public InWithValues(List<? extends Term> values) {
            super(values);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<List<ByteBuffer>> splitValues(QueryOptions options) throws InvalidRequestException {
            ArrayList<List<ByteBuffer>> buffers = new ArrayList<List<ByteBuffer>>(this.values.size());
            for (Term value : this.values) {
                Term.MultiItemTerminal term = (Term.MultiItemTerminal)value.bind(options);
                buffers.add(term.getElements());
            }
            return buffers;
        }
    }

    public static interface IN
    extends MultiColumnRestriction {
        public List<List<ByteBuffer>> splitValues(QueryOptions var1) throws InvalidRequestException;
    }

    public static class EQ
    extends SingleColumnRestriction.EQ
    implements MultiColumnRestriction {
        public EQ(Term value, boolean onToken) {
            super(value, onToken);
        }

        @Override
        public boolean isMultiColumn() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            Tuples.Value t = (Tuples.Value)this.value.bind(options);
            return t.getElements();
        }
    }
}

