/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.util.PoolingSegmentedFile;
import org.apache.cassandra.io.util.SegmentedFile;

public class BufferedPoolingSegmentedFile
extends PoolingSegmentedFile {
    public BufferedPoolingSegmentedFile(String path, long length) {
        super(new PoolingSegmentedFile.Cleanup(path), path, length);
    }

    private BufferedPoolingSegmentedFile(BufferedPoolingSegmentedFile copy) {
        super(copy);
    }

    @Override
    public BufferedPoolingSegmentedFile sharedCopy() {
        return new BufferedPoolingSegmentedFile(this);
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public void addPotentialBoundary(long boundary) {
        }

        @Override
        public SegmentedFile complete(String path, long overrideLength, boolean isFinal) {
            assert (!isFinal || overrideLength <= 0L);
            long length = overrideLength > 0L ? overrideLength : new File(path).length();
            return new BufferedPoolingSegmentedFile(path, length);
        }
    }
}

