/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JVMStabilityInspector {
    private static final Logger logger = LoggerFactory.getLogger(JVMStabilityInspector.class);

    public static void inspectThrowable(Throwable t) {
        boolean isUnstable = false;
        if (t instanceof OutOfMemoryError) {
            isUnstable = true;
        }
        if (isUnstable) {
            t.printStackTrace(System.err);
            logger.error("JVM state determined to be unstable.  Exiting forcefully due to:", t);
            StorageService.instance.removeShutdownHook();
            System.exit(100);
        }
    }
}

