/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;

public class KeyspaceMetrics {
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> memtableOnHeapDataSize;
    public final Gauge<Long> memtableOffHeapDataSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapDataSize;
    public final Gauge<Long> allMemtablesOffHeapDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Gauge<Long> memtableSwitchCount;
    public final Gauge<Long> pendingFlushes;
    public final Gauge<Long> pendingCompactions;
    public final Gauge<Long> liveDiskSpaceUsed;
    public final Gauge<Long> totalDiskSpaceUsed;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Histogram sstablesPerReadHistogram;
    public final Histogram tombstoneScannedHistogram;
    public final Histogram liveScannedHistogram;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final MetricNameFactory factory;
    private Keyspace keyspace;
    private Set<String> allMetrics = Sets.newHashSet();

    public KeyspaceMetrics(Keyspace ks) {
        this.factory = new KeyspaceMetricNameFactory(ks);
        this.keyspace = ks;
        this.memtableColumnsCount = this.createKeyspaceGauge("MemtableColumnsCount", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.memtableColumnsCount.value();
            }
        });
        this.memtableLiveDataSize = this.createKeyspaceGauge("MemtableLiveDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.memtableLiveDataSize.value();
            }
        });
        this.memtableOnHeapDataSize = this.createKeyspaceGauge("MemtableOnHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.memtableOnHeapSize.value();
            }
        });
        this.memtableOffHeapDataSize = this.createKeyspaceGauge("MemtableOffHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.memtableOffHeapSize.value();
            }
        });
        this.allMemtablesLiveDataSize = this.createKeyspaceGauge("AllMemtablesLiveDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.allMemtablesLiveDataSize.value();
            }
        });
        this.allMemtablesOnHeapDataSize = this.createKeyspaceGauge("AllMemtablesOnHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.allMemtablesOnHeapSize.value();
            }
        });
        this.allMemtablesOffHeapDataSize = this.createKeyspaceGauge("AllMemtablesOffHeapDataSize", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.allMemtablesOffHeapSize.value();
            }
        });
        this.memtableSwitchCount = this.createKeyspaceGauge("MemtableSwitchCount", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.memtableSwitchCount.count();
            }
        });
        this.pendingCompactions = this.createKeyspaceGauge("PendingCompactions", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (long)((Integer)metric.pendingCompactions.value());
            }
        });
        this.pendingFlushes = this.createKeyspaceGauge("PendingFlushes", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.pendingFlushes.count();
            }
        });
        this.liveDiskSpaceUsed = this.createKeyspaceGauge("LiveDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.liveDiskSpaceUsed.count();
            }
        });
        this.totalDiskSpaceUsed = this.createKeyspaceGauge("TotalDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return metric.totalDiskSpaceUsed.count();
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createKeyspaceGauge("BloomFilterDiskSpaceUsed", new MetricValue(){

            @Override
            public Long getValue(ColumnFamilyMetrics metric) {
                return (Long)metric.bloomFilterDiskSpaceUsed.value();
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read");
        this.writeLatency = new LatencyMetrics(this.factory, "Write");
        this.rangeLatency = new LatencyMetrics(this.factory, "Range");
        this.sstablesPerReadHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("SSTablesPerReadHistogram"), (boolean)true);
        this.tombstoneScannedHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("TombstoneScannedHistogram"), (boolean)true);
        this.liveScannedHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("LiveScannedHistogram"), (boolean)true);
        this.allMetrics.addAll(Lists.newArrayList((Object[])new String[]{"SSTablesPerReadHistogram", "TombstoneScannedHistogram", "LiveScannedHistogram"}));
        this.casPrepare = new LatencyMetrics(this.factory, "CasPrepare");
        this.casPropose = new LatencyMetrics(this.factory, "CasPropose");
        this.casCommit = new LatencyMetrics(this.factory, "CasCommit");
    }

    public void release() {
        for (String name : this.allMetrics) {
            Metrics.defaultRegistry().removeMetric(this.factory.createMetricName(name));
        }
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
    }

    private <T extends Number> Gauge<Long> createKeyspaceGauge(String name, final MetricValue extractor) {
        this.allMetrics.add(name);
        return Metrics.newGauge((MetricName)this.factory.createMetricName(name), (Gauge)new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                for (ColumnFamilyStore cf : KeyspaceMetrics.this.keyspace.getColumnFamilyStores()) {
                    sum += extractor.getValue(cf.metric).longValue();
                }
                return sum;
            }
        });
    }

    class KeyspaceMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;

        KeyspaceMetricNameFactory(Keyspace ks) {
            this.keyspaceName = ks.getName();
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=Keyspace");
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, "keyspace", metricName, this.keyspaceName, mbeanName.toString());
        }
    }

    private static interface MetricValue {
        public Long getValue(ColumnFamilyMetrics var1);
    }
}

