/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.PreparedQueryNotFoundException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.UUIDGen;

public class ExecuteMessage
extends Message.Request {
    public static final Message.Codec<ExecuteMessage> codec = new Message.Codec<ExecuteMessage>(){

        @Override
        public ExecuteMessage decode(ByteBuf body, int version) {
            byte[] id = CBUtil.readBytes(body);
            if (version == 1) {
                List<ByteBuffer> values = CBUtil.readValueList(body);
                ConsistencyLevel consistency = CBUtil.readConsistencyLevel(body);
                return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.fromProtocolV1(consistency, values));
            }
            return new ExecuteMessage(MD5Digest.wrap(id), QueryOptions.codec.decode(body, version));
        }

        @Override
        public void encode(ExecuteMessage msg, ByteBuf dest, int version) {
            CBUtil.writeBytes(msg.statementId.bytes, dest);
            if (version == 1) {
                CBUtil.writeValueList(msg.options.getValues(), dest);
                CBUtil.writeConsistencyLevel(msg.options.getConsistency(), dest);
            } else {
                QueryOptions.codec.encode(msg.options, dest, version);
            }
        }

        @Override
        public int encodedSize(ExecuteMessage msg, int version) {
            int size = 0;
            size += CBUtil.sizeOfBytes(msg.statementId.bytes);
            if (version == 1) {
                size += CBUtil.sizeOfValueList(msg.options.getValues());
                size += CBUtil.sizeOfConsistencyLevel(msg.options.getConsistency());
            } else {
                size += QueryOptions.codec.encodedSize(msg.options, version);
            }
            return size;
        }
    };
    public final MD5Digest statementId;
    public final QueryOptions options;

    public ExecuteMessage(MD5Digest statementId, QueryOptions options) {
        super(Message.Type.EXECUTE);
        this.statementId = statementId;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message.Response execute(QueryState state) {
        try {
            state.getClientState();
            QueryHandler handler = ClientState.getCQLQueryHandler();
            ParsedStatement.Prepared prepared = handler.getPrepared(this.statementId);
            if (prepared == null) {
                throw new PreparedQueryNotFoundException(this.statementId);
            }
            this.options.prepare(prepared.boundNames);
            CQLStatement statement = prepared.statement;
            if (this.options.getPageSize() == 0) {
                throw new ProtocolException("The page size cannot be 0");
            }
            UUID tracingId = null;
            if (this.isTracingRequested()) {
                tracingId = UUIDGen.getTimeUUID();
                state.prepareTracingSession(tracingId);
            }
            if (state.traceNextQuery()) {
                state.createTracingSession();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                if (this.options.getPageSize() > 0) {
                    builder.put((Object)"page_size", (Object)Integer.toString(this.options.getPageSize()));
                }
                Tracing.instance.begin("Execute CQL3 prepared query", (Map<String, String>)builder.build());
            }
            ResultMessage response = handler.processPrepared(statement, state, this.options);
            if (this.options.skipMetadata() && response instanceof ResultMessage.Rows) {
                ((ResultMessage.Rows)response).result.metadata.setSkipMetadata();
            }
            if (tracingId != null) {
                response.setTracingId(tracingId);
            }
            ResultMessage resultMessage = response;
            return resultMessage;
        }
        catch (Exception e) {
            ErrorMessage errorMessage = ErrorMessage.fromException(e);
            return errorMessage;
        }
        finally {
            Tracing.instance.stopSession();
        }
    }

    public String toString() {
        return "EXECUTE " + this.statementId + " with " + this.options.getValues().size() + " values at consistency " + (Object)((Object)this.options.getConsistency());
    }
}

