/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractDataOutput
extends OutputStream
implements DataOutputPlus {
    private byte[] buf;

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.write(val ? 1 : 0);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.write(val & 0xFF);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        byte[] bytes = new byte[str.length()];
        for (int index = 0; index < str.length(); ++index) {
            bytes[index] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(bytes);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 0 & 0xFF);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        byte[] newBytes = new byte[str.length() * 2];
        for (int index = 0; index < str.length(); ++index) {
            int newIndex = index == 0 ? index : index * 2;
            newBytes[newIndex] = (byte)(str.charAt(index) >> 8 & 0xFF);
            newBytes[newIndex + 1] = (byte)(str.charAt(index) & 0xFF);
        }
        this.write(newBytes);
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.write(val >>> 24 & 0xFF);
        this.write(val >>> 16 & 0xFF);
        this.write(val >>> 8 & 0xFF);
        this.write(val >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.write((int)(val >>> 56) & 0xFF);
        this.write((int)(val >>> 48) & 0xFF);
        this.write((int)(val >>> 40) & 0xFF);
        this.write((int)(val >>> 32) & 0xFF);
        this.write((int)(val >>> 24) & 0xFF);
        this.write((int)(val >>> 16) & 0xFF);
        this.write((int)(val >>> 8) & 0xFF);
        this.write((int)(val >>> 0) & 0xFF);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.writeChar(val);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        int utfCount = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        if (utfCount > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] utfBytes = new byte[utfCount + 2];
        int utfIndex = 2;
        for (int i = 0; i < length; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                utfBytes[utfIndex++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
        }
        utfBytes[0] = (byte)(utfCount >> 8);
        utfBytes[1] = (byte)utfCount;
        this.write(utfBytes);
    }

    @Override
    public synchronized void write(ByteBuffer buffer) throws IOException {
        int len = buffer.remaining();
        if (len < 16) {
            int offset = buffer.position();
            for (int i = 0; i < len; ++i) {
                this.write(buffer.get(i + offset));
            }
            return;
        }
        byte[] buf = this.buf;
        if (buf == null) {
            this.buf = buf = new byte[256];
        }
        int offset = 0;
        while (len > 0) {
            int sublen = Math.min(buf.length, len);
            ByteBufferUtil.arrayCopy(buffer, buffer.position() + offset, buf, 0, sublen);
            this.write(buf, 0, sublen);
            offset += sublen;
            len -= sublen;
        }
    }

    @Override
    public void write(Memory memory) throws IOException {
        for (ByteBuffer buffer : memory.asByteBuffers()) {
            this.write(buffer);
        }
    }
}

