/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractCompoundCellNameType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundCType;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.db.composites.CompoundSparseCellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CompoundSparseCellNameType
extends AbstractCompoundCellNameType {
    public static final ColumnIdentifier rowMarkerId = new ColumnIdentifier(ByteBufferUtil.EMPTY_BYTE_BUFFER, UTF8Type.instance);
    private static final CellName rowMarkerNoPrefix = new CompoundSparseCellName(rowMarkerId, false);
    private final AbstractType<?> columnNameType;
    protected final Map<ByteBuffer, ColumnIdentifier> internedIds;
    private final Composite staticPrefix;
    private final boolean isByteOrderComparable;

    public CompoundSparseCellNameType(List<AbstractType<?>> types) {
        this(types, UTF8Type.instance);
    }

    public CompoundSparseCellNameType(List<AbstractType<?>> types, AbstractType<?> columnNameType) {
        this(new CompoundCType(types), columnNameType);
    }

    private CompoundSparseCellNameType(CompoundCType clusteringType, AbstractType<?> columnNameType) {
        this(clusteringType, columnNameType, CompoundSparseCellNameType.makeCType(clusteringType, columnNameType, null), new HashMap<ByteBuffer, ColumnIdentifier>());
    }

    private CompoundSparseCellNameType(CompoundCType clusteringType, AbstractType<?> columnNameType, CompoundCType fullType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
        super(clusteringType, fullType);
        this.columnNameType = columnNameType;
        this.internedIds = internedIds;
        this.staticPrefix = CompoundSparseCellNameType.makeStaticPrefix(clusteringType.size());
        this.isByteOrderComparable = CompoundSparseCellNameType.isByteOrderComparable(fullType.types);
    }

    private static Composite makeStaticPrefix(int size) {
        ByteBuffer[] elements = new ByteBuffer[size];
        for (int i = 0; i < size; ++i) {
            elements[i] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        return new CompoundComposite(elements, size, true){

            @Override
            public boolean isStatic() {
                return true;
            }

            @Override
            public long unsharedHeapSize() {
                return 0L;
            }

            @Override
            public Composite copy(CFMetaData cfm, AbstractAllocator allocator) {
                return this;
            }
        };
    }

    protected static CompoundCType makeCType(CompoundCType clusteringType, AbstractType<?> columnNameType, ColumnToCollectionType collectionType) {
        ArrayList allSubtypes = new ArrayList(clusteringType.size() + (collectionType == null ? 1 : 2));
        for (int i = 0; i < clusteringType.size(); ++i) {
            allSubtypes.add(clusteringType.subtype(i));
        }
        allSubtypes.add(columnNameType);
        if (collectionType != null) {
            allSubtypes.add(collectionType);
        }
        return new CompoundCType(allSubtypes);
    }

    @Override
    public CellNameType setSubtype(int position, AbstractType<?> newType) {
        if (position < this.clusteringSize) {
            return new CompoundSparseCellNameType((CompoundCType)this.clusteringType.setSubtype(position, (AbstractType)newType), this.columnNameType, (CompoundCType)this.fullType.setSubtype(position, (AbstractType)newType), this.internedIds);
        }
        if (position == this.clusteringSize) {
            throw new IllegalArgumentException();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CellNameType addOrUpdateCollection(ColumnIdentifier columnName, CollectionType newCollection) {
        return new WithCollection(this.clusteringType, ColumnToCollectionType.getInstance(Collections.singletonMap(columnName.bytes, newCollection)), this.internedIds);
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean supportCollections() {
        return true;
    }

    @Override
    public Composite staticPrefix() {
        return this.staticPrefix;
    }

    @Override
    public CellName create(Composite prefix, ColumnDefinition column) {
        return this.create(prefix, column.name, column.isStatic());
    }

    private CellName create(Composite prefix, ColumnIdentifier columnName, boolean isStatic) {
        if (isStatic) {
            prefix = this.staticPrefix();
        }
        assert (prefix.size() == this.clusteringSize);
        if (prefix.isEmpty()) {
            return new CompoundSparseCellName(columnName, isStatic);
        }
        assert (prefix instanceof CompoundComposite);
        CompoundComposite lc = (CompoundComposite)prefix;
        return new CompoundSparseCellName(lc.elements, this.clusteringSize, columnName, isStatic);
    }

    @Override
    public CellName rowMarker(Composite prefix) {
        assert (!prefix.isStatic());
        if (prefix.isEmpty()) {
            return rowMarkerNoPrefix;
        }
        return this.create(prefix, rowMarkerId, false);
    }

    protected ColumnIdentifier idFor(ByteBuffer bb) {
        ColumnIdentifier id = this.internedIds.get(bb);
        return id == null ? new ColumnIdentifier(bb, this.columnNameType) : id;
    }

    @Override
    protected Composite makeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
        if (size < this.clusteringSize + 1 || eoc != Composite.EOC.NONE) {
            return new CompoundComposite(components, size, isStatic).withEOC(eoc);
        }
        return new CompoundSparseCellName(components, this.clusteringSize, this.idFor(components[this.clusteringSize]), isStatic);
    }

    @Override
    protected Composite copyAndMakeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
        if (size < this.clusteringSize + 1 || eoc != Composite.EOC.NONE) {
            return new CompoundComposite(Arrays.copyOfRange(components, 0, size), size, isStatic).withEOC(eoc);
        }
        ByteBuffer[] clusteringColumns = Arrays.copyOfRange(components, 0, this.clusteringSize);
        return new CompoundSparseCellName(clusteringColumns, this.idFor(components[this.clusteringSize]), isStatic);
    }

    @Override
    public void addCQL3Column(ColumnIdentifier id) {
        this.internedIds.put(id.bytes, id);
    }

    @Override
    public void removeCQL3Column(ColumnIdentifier id) {
        this.internedIds.remove(id.bytes);
    }

    @Override
    public CQL3Row.Builder CQL3RowBuilder(CFMetaData metadata, long now) {
        return CompoundSparseCellNameType.makeSparseCQL3RowBuilder(metadata, this, now);
    }

    public static class WithCollection
    extends CompoundSparseCellNameType {
        private final ColumnToCollectionType collectionType;

        public WithCollection(List<AbstractType<?>> types, ColumnToCollectionType collectionType) {
            this(new CompoundCType(types), collectionType);
        }

        WithCollection(CompoundCType clusteringType, ColumnToCollectionType collectionType) {
            this(clusteringType, collectionType, new HashMap<ByteBuffer, ColumnIdentifier>());
        }

        private WithCollection(CompoundCType clusteringType, ColumnToCollectionType collectionType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
            this(clusteringType, WithCollection.makeCType(clusteringType, UTF8Type.instance, collectionType), collectionType, internedIds);
        }

        private WithCollection(CompoundCType clusteringType, CompoundCType fullCType, ColumnToCollectionType collectionType, Map<ByteBuffer, ColumnIdentifier> internedIds) {
            super(clusteringType, UTF8Type.instance, fullCType, internedIds);
            this.collectionType = collectionType;
        }

        @Override
        public CellNameType setSubtype(int position, AbstractType<?> newType) {
            if (position < this.clusteringSize) {
                return new WithCollection((CompoundCType)this.clusteringType.setSubtype(position, (AbstractType)newType), this.collectionType, this.internedIds);
            }
            throw position >= this.fullType.size() ? new IndexOutOfBoundsException() : new IllegalArgumentException();
        }

        @Override
        public CellNameType addOrUpdateCollection(ColumnIdentifier columnName, CollectionType newCollection) {
            HashMap<ByteBuffer, CollectionType> newMap = new HashMap<ByteBuffer, CollectionType>(this.collectionType.defined);
            newMap.put(columnName.bytes, newCollection);
            return new WithCollection(this.clusteringType, ColumnToCollectionType.getInstance(newMap), this.internedIds);
        }

        @Override
        public CellName create(Composite prefix, ColumnDefinition column, ByteBuffer collectionElement) {
            if (column.isStatic()) {
                prefix = this.staticPrefix();
            }
            assert (prefix.size() == this.clusteringSize);
            if (prefix.isEmpty()) {
                return new CompoundSparseCellName.WithCollection(column.name, collectionElement, column.isStatic());
            }
            assert (prefix instanceof CompoundComposite);
            CompoundComposite lc = (CompoundComposite)prefix;
            return new CompoundSparseCellName.WithCollection(lc.elements, this.clusteringSize, column.name, collectionElement, column.isStatic());
        }

        @Override
        public int compare(Composite c1, Composite c2) {
            if (c1.isStatic() != c2.isStatic()) {
                if (c1.isEmpty()) {
                    return c2.isEmpty() ? 0 : -1;
                }
                if (c2.isEmpty()) {
                    return 1;
                }
                return c1.isStatic() ? -1 : 1;
            }
            int s1 = c1.size();
            int s2 = c2.size();
            int minSize = Math.min(s1, s2);
            ByteBuffer previous = null;
            for (int i = 0; i < minSize; ++i) {
                ByteBuffer value2;
                ByteBuffer value1;
                AbstractType<?> comparator = this.subtype(i);
                int cmp = comparator.compareCollectionMembers(value1 = c1.get(i), value2 = c2.get(i), previous);
                if (cmp != 0) {
                    return cmp;
                }
                previous = value1;
            }
            if (s1 == s2) {
                return c1.eoc().compareTo(c2.eoc());
            }
            return s1 < s2 ? c1.eoc().prefixComparisonResult : -c2.eoc().prefixComparisonResult;
        }

        @Override
        public boolean hasCollections() {
            return true;
        }

        @Override
        public ColumnToCollectionType collectionType() {
            return this.collectionType;
        }

        @Override
        protected Composite makeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
            if (size < this.fullSize) {
                return super.makeWith(components, size, eoc, isStatic);
            }
            return new CompoundSparseCellName.WithCollection(components, this.clusteringSize, this.idFor(components[this.clusteringSize]), components[this.fullSize - 1], isStatic);
        }

        @Override
        protected Composite copyAndMakeWith(ByteBuffer[] components, int size, Composite.EOC eoc, boolean isStatic) {
            if (size < this.fullSize) {
                return super.copyAndMakeWith(components, size, eoc, isStatic);
            }
            ByteBuffer[] clusteringColumns = Arrays.copyOfRange(components, 0, this.clusteringSize);
            return new CompoundSparseCellName.WithCollection(clusteringColumns, this.idFor(components[this.clusteringSize]), components[this.clusteringSize + 1], isStatic);
        }
    }
}

