/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnCondition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.service.CASConditions;
import org.apache.cassandra.utils.Pair;

public class CQL3CasConditions
implements CASConditions {
    private final CFMetaData cfm;
    private final long now;
    private final SortedMap<Composite, RowCondition> conditions;

    public CQL3CasConditions(CFMetaData cfm, long now) {
        this.cfm = cfm;
        this.now = now / 1000L;
        this.conditions = new TreeMap<Composite, RowCondition>(cfm.comparator);
    }

    public void addNotExist(Composite prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix, new NotExistCondition(prefix, this.now));
        if (previous != null && !(previous instanceof NotExistCondition)) {
            if (previous instanceof ExistCondition) {
                throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
            }
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
    }

    public void addExist(Composite prefix) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(prefix, new ExistCondition(prefix, this.now));
        if (previous != null && previous instanceof NotExistCondition) {
            throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
        }
    }

    public void addConditions(Composite prefix, Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
        RowCondition condition = (RowCondition)this.conditions.get(prefix);
        if (condition == null) {
            condition = new ColumnsConditions(prefix, this.now);
            this.conditions.put(prefix, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, options);
    }

    @Override
    public IDiskAtomFilter readFilter() {
        int toGroup;
        assert (!this.conditions.isEmpty());
        ColumnSlice[] slices = new ColumnSlice[this.conditions.size()];
        int i = 0;
        for (Composite prefix : this.conditions.keySet()) {
            slices[i++] = prefix.slice();
        }
        int n = toGroup = this.cfm.comparator.isDense() ? -1 : this.cfm.clusteringColumns().size();
        assert (ColumnSlice.validateSlices(slices, this.cfm.comparator, false));
        return new SliceQueryFilter(slices, false, slices.length, toGroup);
    }

    @Override
    public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Map<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = new HashMap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound>();

        private ColumnsConditions(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        public void addConditions(Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(options);
                ColumnCondition.Bound previous = this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), current);
                if (previous == null || previous.equals(current)) continue;
                throw new InvalidRequestException("Duplicate and incompatible conditions for column " + condition.column.name);
            }
        }

        @Override
        public boolean appliesTo(ColumnFamily current) throws InvalidRequestException {
            if (current == null) {
                return this.conditions.isEmpty();
            }
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(this.rowPrefix, current, this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return false;
            }
            Iterator<Cell> iter = current.iterator(new ColumnSlice[]{this.rowPrefix.slice()});
            while (iter.hasNext()) {
                if (!iter.next().isLive(this.now)) continue;
                return true;
            }
            return false;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(Composite rowPrefix, long now) {
            super(rowPrefix, now);
        }

        @Override
        public boolean appliesTo(ColumnFamily current) {
            if (current == null) {
                return true;
            }
            Iterator<Cell> iter = current.iterator(new ColumnSlice[]{this.rowPrefix.slice()});
            while (iter.hasNext()) {
                if (!iter.next().isLive(this.now)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class RowCondition {
        public final Composite rowPrefix;
        protected final long now;

        protected RowCondition(Composite rowPrefix, long now) {
            this.rowPrefix = rowPrefix;
            this.now = now;
        }

        public abstract boolean appliesTo(ColumnFamily var1) throws InvalidRequestException;
    }
}

