/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Queue;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.Builder;
import org.apache.cassandra.utils.btree.Cursor;
import org.apache.cassandra.utils.btree.UpdateFunction;

public class BTree {
    static final int FAN_SHIFT;
    static final int FAN_FACTOR;
    static final Object[] EMPTY_LEAF;
    static final Object[] EMPTY_BRANCH;
    static final Special POSITIVE_INFINITY;
    static final Special NEGATIVE_INFINITY;
    private static final ThreadLocal<Queue<Builder>> modifier;

    public static Object[] empty() {
        return EMPTY_LEAF;
    }

    public static <V> Object[] build(Collection<V> source, Comparator<V> comparator, boolean sorted, UpdateFunction<V> updateF) {
        return BTree.build(source, source.size(), comparator, sorted, updateF);
    }

    public static <V> Object[] build(Iterable<V> source, int size, Comparator<V> comparator, boolean sorted, UpdateFunction<V> updateF) {
        Queue<Builder> queue;
        Builder builder;
        if (size < FAN_FACTOR) {
            Object[] values = new Object[size + (size & 1)];
            int i = 0;
            for (V v : source) {
                values[i++] = v;
            }
            if (!sorted) {
                Arrays.sort(values, 0, size, comparator);
            }
            if (updateF != null) {
                for (i = 0; i < size; ++i) {
                    values[i] = updateF.apply(values[i]);
                }
                updateF.allocated(ObjectSizes.sizeOfArray(values));
            }
            return values;
        }
        if (!sorted) {
            source = BTree.sorted(source, comparator, size);
        }
        if ((builder = (queue = modifier.get()).poll()) == null) {
            builder = new Builder();
        }
        Object[] btree = builder.build(source, updateF, size);
        queue.add(builder);
        return btree;
    }

    public static <V> Object[] update(Object[] btree, Comparator<V> comparator, Collection<V> updateWith, boolean updateWithIsSorted) {
        return BTree.update(btree, comparator, updateWith, updateWithIsSorted, UpdateFunction.NoOp.instance());
    }

    public static <V> Object[] update(Object[] btree, Comparator<V> comparator, Collection<V> updateWith, boolean updateWithIsSorted, UpdateFunction<V> updateF) {
        return BTree.update(btree, comparator, updateWith, updateWith.size(), updateWithIsSorted, updateF);
    }

    public static <V> Object[] update(Object[] btree, Comparator<V> comparator, Iterable<V> updateWith, int updateWithLength, boolean updateWithIsSorted, UpdateFunction<V> updateF) {
        Queue<Builder> queue;
        Builder builder;
        if (btree.length == 0) {
            return BTree.build(updateWith, updateWithLength, comparator, updateWithIsSorted, updateF);
        }
        if (!updateWithIsSorted) {
            updateWith = BTree.sorted(updateWith, comparator, updateWithLength);
        }
        if ((builder = (queue = modifier.get()).poll()) == null) {
            builder = new Builder();
        }
        btree = builder.update(btree, comparator, updateWith, updateF);
        queue.add(builder);
        return btree;
    }

    public static <V> Cursor<V> slice(Object[] btree, boolean forwards) {
        Cursor r = new Cursor();
        r.reset(btree, forwards);
        return r;
    }

    public static <V> Cursor<V> slice(Object[] btree, Comparator<V> comparator, V start, V end, boolean forwards) {
        Cursor<V> r = new Cursor<V>();
        r.reset(btree, comparator, start, end, forwards);
        return r;
    }

    public static <V> Cursor<V> slice(Object[] btree, Comparator<V> comparator, V start, boolean startInclusive, V end, boolean endInclusive, boolean forwards) {
        Cursor<V> r = new Cursor<V>();
        r.reset(btree, comparator, start, startInclusive, end, endInclusive, forwards);
        return r;
    }

    public static <V> V find(Object[] node, Comparator<V> comparator, V find) {
        while (true) {
            int keyEnd;
            int i;
            if ((i = BTree.find(comparator, find, node, 0, keyEnd = BTree.getKeyEnd(node))) >= 0) {
                return (V)node[i];
            }
            if (BTree.isLeaf(node)) break;
            i = -i - 1;
            node = (Object[])node[keyEnd + i];
        }
        return null;
    }

    static <V> int find(Comparator<V> comparator, Object key, Object[] a, int fromIndex, int toIndex) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = comparator.compare(key, a[mid]);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static int getKeyEnd(Object[] node) {
        if (BTree.isLeaf(node)) {
            return BTree.getLeafKeyEnd(node);
        }
        return BTree.getBranchKeyEnd(node);
    }

    static int getLeafKeyEnd(Object[] node) {
        int len = node.length;
        if (len == 0) {
            return 0;
        }
        if (node[len - 1] == null) {
            return len - 1;
        }
        return len;
    }

    static int getBranchKeyEnd(Object[] node) {
        return node.length / 2;
    }

    static boolean isLeaf(Object[] node) {
        return (node.length & 1) == 0;
    }

    public static boolean isEmpty(Object[] tree) {
        return tree.length == 0;
    }

    public static int depth(Object[] tree) {
        int depth = 1;
        while (!BTree.isLeaf(tree)) {
            ++depth;
            tree = (Object[])tree[BTree.getKeyEnd(tree)];
        }
        return depth;
    }

    private static <V> Collection<V> sorted(Iterable<V> source, Comparator<V> comparator, int size) {
        Object[] vs = new Object[size];
        int i = 0;
        for (V v : source) {
            vs[i++] = v;
        }
        Arrays.sort(vs, comparator);
        return Arrays.asList(vs);
    }

    static <V> int compare(Comparator<V> cmp, Object a, Object b) {
        if (a instanceof Special) {
            return ((Special)a).compareTo(b);
        }
        if (b instanceof Special) {
            return -((Special)b).compareTo(a);
        }
        return cmp.compare(a, b);
    }

    public static boolean isWellFormed(Object[] btree, Comparator<? extends Object> cmp) {
        return BTree.isWellFormed(cmp, btree, true, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private static boolean isWellFormed(Comparator<?> cmp, Object[] node, boolean isRoot, Object min, Object max) {
        int childOffset;
        if (cmp != null && !BTree.isNodeWellFormed(cmp, node, min, max)) {
            return false;
        }
        if (BTree.isLeaf(node)) {
            if (isRoot) {
                return node.length <= FAN_FACTOR;
            }
            return node.length >= FAN_FACTOR / 2 && node.length <= FAN_FACTOR;
        }
        int type = 0;
        for (int i = childOffset = BTree.getBranchKeyEnd(node); i < node.length; ++i) {
            Object localmax;
            Object[] child = (Object[])node[i];
            Object object = localmax = i < node.length - 1 ? node[i - childOffset] : max;
            if (!BTree.isWellFormed(cmp, child, false, min, localmax)) {
                return false;
            }
            type |= BTree.isLeaf(child) ? 1 : 2;
            min = localmax;
        }
        return type < 3;
    }

    private static boolean isNodeWellFormed(Comparator<?> cmp, Object[] node, Object min, Object max) {
        Object previous = min;
        int end = BTree.getKeyEnd(node);
        for (int i = 0; i < end; ++i) {
            Object current = node[i];
            if (BTree.compare(cmp, previous, current) >= 0) {
                return false;
            }
            previous = current;
        }
        return BTree.compare(cmp, previous, max) < 0;
    }

    static {
        int fanfactor = 32;
        if (System.getProperty("cassandra.btree.fanfactor") != null) {
            fanfactor = Integer.parseInt(System.getProperty("cassandra.btree.fanfactor"));
        }
        int shift = 1;
        while (1 << shift < fanfactor) {
            ++shift;
        }
        FAN_SHIFT = shift;
        FAN_FACTOR = 1 << FAN_SHIFT;
        EMPTY_LEAF = new Object[0];
        EMPTY_BRANCH = new Object[1];
        POSITIVE_INFINITY = new Special(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : 1;
            }
        };
        NEGATIVE_INFINITY = new Special(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : -1;
            }
        };
        modifier = new ThreadLocal<Queue<Builder>>(){

            @Override
            protected Queue<Builder> initialValue() {
                return new ArrayDeque<Builder>();
            }
        };
    }

    static interface Special
    extends Comparable<Object> {
    }
}

