/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.CLibrary;

public class SSTableRewriter {
    private static final long preemptiveOpenInterval;
    private final DataTracker dataTracker;
    private final ColumnFamilyStore cfs;
    private final long maxAge;
    private final Set<SSTableReader> rewriting;
    private final Map<Descriptor, DecoratedKey> originalStarts = new HashMap<Descriptor, DecoratedKey>();
    private final Map<Descriptor, Integer> fileDescriptors = new HashMap<Descriptor, Integer>();
    private SSTableReader currentlyOpenedEarly;
    private long currentlyOpenedEarlyAt;
    private final List<SSTableReader> finished = new ArrayList<SSTableReader>();
    private final OperationType rewriteType;
    private final boolean isOffline;
    private SSTableWriter writer;
    private Map<DecoratedKey, RowIndexEntry> cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();

    public SSTableRewriter(ColumnFamilyStore cfs, Set<SSTableReader> rewriting, long maxAge, OperationType rewriteType, boolean isOffline) {
        this.rewriting = rewriting;
        for (SSTableReader sstable : rewriting) {
            this.originalStarts.put(sstable.descriptor, sstable.first);
            this.fileDescriptors.put(sstable.descriptor, CLibrary.getfd(sstable.getFilename()));
        }
        this.dataTracker = cfs.getDataTracker();
        this.cfs = cfs;
        this.maxAge = maxAge;
        this.rewriteType = rewriteType;
        this.isOffline = isOffline;
    }

    public SSTableWriter currentWriter() {
        return this.writer;
    }

    public RowIndexEntry append(AbstractCompactedRow row) {
        this.maybeReopenEarly(row.key);
        RowIndexEntry index = this.writer.append(row);
        if (!this.isOffline) {
            if (index == null) {
                this.cfs.invalidateCachedRow(row.key);
            } else {
                boolean save = false;
                for (SSTableReader reader : this.rewriting) {
                    if (reader.getCachedPosition(row.key, false) == null) continue;
                    save = true;
                    break;
                }
                if (save) {
                    this.cachedKeys.put(row.key, index);
                }
            }
        }
        return index;
    }

    public RowIndexEntry tryAppend(AbstractCompactedRow row) {
        this.mark();
        try {
            return this.append(row);
        }
        catch (Throwable t) {
            this.resetAndTruncate();
            throw t;
        }
    }

    private void mark() {
        this.writer.mark();
    }

    private void resetAndTruncate() {
        this.writer.resetAndTruncate();
    }

    private void maybeReopenEarly(DecoratedKey key) {
        if (this.writer.getFilePointer() - this.currentlyOpenedEarlyAt > preemptiveOpenInterval) {
            if (this.isOffline) {
                for (SSTableReader reader : this.rewriting) {
                    RowIndexEntry index = reader.getPosition(key, SSTableReader.Operator.GE);
                    CLibrary.trySkipCache((int)this.fileDescriptors.get(reader.descriptor), 0L, index == null ? 0L : index.position);
                }
            } else {
                SSTableReader reader = this.writer.openEarly(this.maxAge);
                if (reader != null) {
                    this.replaceReader(this.currentlyOpenedEarly, reader);
                    this.currentlyOpenedEarly = reader;
                    this.currentlyOpenedEarlyAt = this.writer.getFilePointer();
                    this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
                }
            }
        }
    }

    public void abort() {
        if (this.writer == null) {
            return;
        }
        this.moveStarts(null, (Function<? super Descriptor, DecoratedKey>)Functions.forMap(this.originalStarts), true);
        ArrayList<SSTableReader> close = new ArrayList<SSTableReader>(this.finished);
        if (this.currentlyOpenedEarly != null) {
            close.add(this.currentlyOpenedEarly);
        }
        for (SSTableReader sstable : close) {
            sstable.markObsolete();
        }
        if (!this.isOffline) {
            this.dataTracker.replaceReaders(close, Collections.emptyList());
            this.dataTracker.unmarkCompacting(close);
        }
        this.writer.abort();
    }

    private void moveStarts(SSTableReader newReader, Function<? super Descriptor, DecoratedKey> newStarts, boolean reset) {
        if (this.isOffline) {
            return;
        }
        ArrayList<SSTableReader> toReplace = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> replaceWith = new ArrayList<SSTableReader>();
        final ArrayList<DecoratedKey> invalidateKeys = new ArrayList<DecoratedKey>();
        if (!reset) {
            invalidateKeys.addAll(this.cachedKeys.keySet());
            for (Map.Entry entry : this.cachedKeys.entrySet()) {
                newReader.cacheKey((DecoratedKey)entry.getKey(), (RowIndexEntry)entry.getValue());
            }
        }
        this.cachedKeys = new HashMap<DecoratedKey, RowIndexEntry>();
        for (final SSTableReader sSTableReader : this.rewriting) {
            DecoratedKey newStart = (DecoratedKey)newStarts.apply((Object)sSTableReader.descriptor);
            assert (newStart != null);
            if (sSTableReader.first.compareTo(newStart) >= 0 && (!reset || newStart == sSTableReader.first)) continue;
            toReplace.add(sSTableReader);
            replaceWith.add(sSTableReader.getCurrentReplacement().cloneWithNewStart(newStart, new Runnable(){

                @Override
                public void run() {
                    for (DecoratedKey key : invalidateKeys) {
                        sSTableReader.invalidateCacheKey(key);
                    }
                }
            }));
        }
        this.replaceReaders(toReplace, replaceWith);
        this.rewriting.removeAll(toReplace);
        this.rewriting.addAll(replaceWith);
    }

    private void replaceReader(SSTableReader toReplace, SSTableReader replaceWith) {
        Set<SSTableReader> toReplaceSet;
        if (this.isOffline) {
            return;
        }
        if (toReplace != null) {
            toReplace.setReplacedBy(replaceWith);
            toReplaceSet = Collections.singleton(toReplace);
        } else {
            this.dataTracker.markCompacting(Collections.singleton(replaceWith));
            toReplaceSet = Collections.emptySet();
        }
        this.replaceReaders(toReplaceSet, Collections.singleton(replaceWith));
    }

    private void replaceReaders(Collection<SSTableReader> toReplace, Collection<SSTableReader> replaceWith) {
        if (this.isOffline) {
            return;
        }
        this.dataTracker.replaceReaders(toReplace, replaceWith);
    }

    public void switchWriter(SSTableWriter newWriter) {
        if (this.writer == null) {
            this.writer = newWriter;
            return;
        }
        SSTableReader reader = this.writer.closeAndOpenReader(this.maxAge);
        this.finished.add(reader);
        this.replaceReader(this.currentlyOpenedEarly, reader);
        this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
        this.currentlyOpenedEarly = null;
        this.currentlyOpenedEarlyAt = 0L;
        this.writer = newWriter;
    }

    public void finish() {
        this.finish(-1L);
    }

    public void finish(long repairedAt) {
        this.finish(true, repairedAt);
    }

    public void finish(boolean cleanupOldReaders) {
        this.finish(cleanupOldReaders, -1L);
    }

    public void finish(boolean cleanupOldReaders, long repairedAt) {
        if (this.writer.getFilePointer() > 0L) {
            SSTableReader reader = repairedAt < 0L ? this.writer.closeAndOpenReader(this.maxAge) : this.writer.closeAndOpenReader(this.maxAge, repairedAt);
            this.finished.add(reader);
            this.replaceReader(this.currentlyOpenedEarly, reader);
            this.moveStarts(reader, (Function<? super Descriptor, DecoratedKey>)Functions.constant((Object)reader.last), false);
        } else {
            this.writer.abort();
            this.writer = null;
        }
        if (!this.isOffline) {
            this.dataTracker.unmarkCompacting(this.finished);
            if (cleanupOldReaders) {
                this.dataTracker.markCompactedSSTablesReplaced(this.rewriting, this.finished, this.rewriteType);
            }
        } else if (cleanupOldReaders) {
            for (SSTableReader reader : this.rewriting) {
                reader.markObsolete();
                reader.releaseReference();
            }
        }
    }

    public List<SSTableReader> finished() {
        return this.finished;
    }

    static {
        long interval = (long)DatabaseDescriptor.getSSTablePreempiveOpenIntervalInMB() * 0x100000L;
        if (interval < 0L) {
            interval = Long.MAX_VALUE;
        }
        preemptiveOpenInterval = interval;
    }
}

