/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CompoundDenseCellName
extends CompoundComposite
implements CellName {
    private static final long HEAP_SIZE = ObjectSizes.measure(new CompoundDenseCellName(new ByteBuffer[0]));

    CompoundDenseCellName(ByteBuffer[] elements) {
        super(elements, elements.length, false);
    }

    CompoundDenseCellName(ByteBuffer[] elements, int size) {
        super(elements, size, false);
    }

    @Override
    public int clusteringSize() {
        return this.size;
    }

    @Override
    public ColumnIdentifier cql3ColumnName(CFMetaData metadata) {
        return null;
    }

    @Override
    public ByteBuffer collectionElement() {
        return null;
    }

    @Override
    public boolean isCollectionCell() {
        return false;
    }

    @Override
    public boolean isSameCQL3RowAs(CellNameType type, CellName other) {
        return type.compare(this, other) == 0;
    }

    @Override
    public long unsharedHeapSize() {
        return HEAP_SIZE + ObjectSizes.sizeOnHeapOf(this.elements);
    }

    @Override
    public long excessHeapSizeExcludingData() {
        return HEAP_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.elements);
    }

    @Override
    public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
        return new CompoundDenseCellName(this.elementsCopy(allocator));
    }
}

