/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;

public class DataRange {
    private final AbstractBounds<RowPosition> keyRange;
    protected IDiskAtomFilter columnFilter;
    protected final boolean selectFullRow;

    public DataRange(AbstractBounds<RowPosition> range, IDiskAtomFilter columnFilter) {
        this.keyRange = range;
        this.columnFilter = columnFilter;
        this.selectFullRow = columnFilter instanceof SliceQueryFilter ? DataRange.isFullRowSlice((SliceQueryFilter)columnFilter) : false;
    }

    public static boolean isFullRowSlice(SliceQueryFilter filter) {
        return filter.slices.length == 1 && filter.start().isEmpty() && filter.finish().isEmpty() && filter.count == Integer.MAX_VALUE;
    }

    public static DataRange allData(IPartitioner partitioner) {
        return DataRange.forKeyRange(new Range<Token>((Token)partitioner.getMinimumToken(), (Token)partitioner.getMinimumToken()));
    }

    public static DataRange forKeyRange(Range<Token> keyRange) {
        return new DataRange(keyRange.toRowBounds(), new IdentityQueryFilter());
    }

    public AbstractBounds<RowPosition> keyRange() {
        return this.keyRange;
    }

    public RowPosition startKey() {
        return (RowPosition)this.keyRange.left;
    }

    public RowPosition stopKey() {
        return (RowPosition)this.keyRange.right;
    }

    public boolean isWrapAround() {
        return this.keyRange instanceof Range && ((Range)this.keyRange).isWrapAround();
    }

    public boolean contains(RowPosition pos) {
        return this.keyRange.contains(pos);
    }

    public int getLiveCount(ColumnFamily data, long now) {
        return this.columnFilter instanceof SliceQueryFilter ? ((SliceQueryFilter)this.columnFilter).lastCounted() : this.columnFilter.getLiveCount(data, now);
    }

    public boolean selectsFullRowFor(ByteBuffer rowKey) {
        return this.selectFullRow;
    }

    public IDiskAtomFilter columnFilter(ByteBuffer rowKey) {
        return this.columnFilter;
    }

    public void updateColumnsLimit(int count) {
        this.columnFilter.updateColumnsLimit(count);
    }

    public static class Paging
    extends DataRange {
        private final SliceQueryFilter sliceFilter;
        private final Comparator<Composite> comparator;
        private final Composite columnStart;
        private final Composite columnFinish;

        private Paging(AbstractBounds<RowPosition> range, SliceQueryFilter filter, Composite columnStart, Composite columnFinish, Comparator<Composite> comparator) {
            super(range, filter);
            assert (!(range instanceof Range) || !((Range)range).isWrapAround() || ((RowPosition)range.right).isMinimum()) : range;
            this.sliceFilter = filter;
            this.comparator = comparator;
            this.columnStart = columnStart;
            this.columnFinish = columnFinish;
        }

        public Paging(AbstractBounds<RowPosition> range, SliceQueryFilter filter, Composite columnStart, Composite columnFinish, CellNameType comparator) {
            this(range, filter, columnStart, columnFinish, filter.isReversed() ? comparator.reverseComparator() : comparator);
        }

        @Override
        public boolean selectsFullRowFor(ByteBuffer rowKey) {
            if (!this.selectFullRow) {
                return false;
            }
            if (!this.equals(this.startKey(), rowKey) && !this.equals(this.stopKey(), rowKey)) {
                return this.selectFullRow;
            }
            return Paging.isFullRowSlice((SliceQueryFilter)this.columnFilter(rowKey));
        }

        private boolean equals(RowPosition pos, ByteBuffer rowKey) {
            return pos instanceof DecoratedKey && ((DecoratedKey)pos).getKey().equals(rowKey);
        }

        @Override
        public IDiskAtomFilter columnFilter(ByteBuffer rowKey) {
            this.columnFilter = this.equals(this.startKey(), rowKey) || this.equals(this.stopKey(), rowKey) ? this.sliceFilter.withUpdatedSlices(this.slicesForKey(rowKey)) : this.sliceFilter;
            return this.columnFilter;
        }

        private ColumnSlice[] slicesForKey(ByteBuffer key) {
            Composite newStart = this.equals(this.startKey(), key) && !this.columnStart.isEmpty() ? this.columnStart : null;
            Composite newFinish = this.equals(this.stopKey(), key) && !this.columnFinish.isEmpty() ? this.columnFinish : null;
            ArrayList<ColumnSlice> newSlices = new ArrayList<ColumnSlice>(this.sliceFilter.slices.length);
            for (ColumnSlice slice : this.sliceFilter.slices) {
                if (newStart != null) {
                    if (slice.isBefore(this.comparator, newStart)) continue;
                    if (slice.includes(this.comparator, newStart)) {
                        slice = new ColumnSlice(newStart, slice.finish);
                    }
                    newStart = null;
                }
                assert (newStart == null);
                if (newFinish != null && !slice.isBefore(this.comparator, newFinish)) {
                    if (!slice.includes(this.comparator, newFinish)) break;
                    newSlices.add(new ColumnSlice(slice.start, newFinish));
                    break;
                }
                newSlices.add(slice);
            }
            return newSlices.toArray(new ColumnSlice[newSlices.size()]);
        }

        @Override
        public void updateColumnsLimit(int count) {
            this.columnFilter.updateColumnsLimit(count);
            this.sliceFilter.updateColumnsLimit(count);
        }
    }
}

