/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class AtomicBTreeColumns
extends ColumnFamily {
    static final long EMPTY_SIZE = ObjectSizes.measure(new AtomicBTreeColumns(CFMetaData.IndexCf, null)) + ObjectSizes.measure(new Holder(null, null));
    private static final Function<Cell, CellName> NAME = new Function<Cell, CellName>(){

        public CellName apply(Cell column) {
            return column.name();
        }
    };
    public static final ColumnFamily.Factory<AtomicBTreeColumns> factory = new ColumnFamily.Factory<AtomicBTreeColumns>(){

        @Override
        public AtomicBTreeColumns create(CFMetaData metadata, boolean insertReversed, int initialCapacity) {
            if (insertReversed) {
                throw new IllegalArgumentException();
            }
            return new AtomicBTreeColumns(metadata);
        }
    };
    private static final DeletionInfo LIVE = DeletionInfo.live();
    private static final Holder EMPTY = new Holder(BTree.empty(), LIVE);
    private volatile Holder ref;
    private static final AtomicReferenceFieldUpdater<AtomicBTreeColumns, Holder> refUpdater = AtomicReferenceFieldUpdater.newUpdater(AtomicBTreeColumns.class, Holder.class, "ref");

    private AtomicBTreeColumns(CFMetaData metadata) {
        this(metadata, EMPTY);
    }

    private AtomicBTreeColumns(CFMetaData metadata, Holder holder) {
        super(metadata);
        this.ref = holder;
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new AtomicBTreeColumns(this.metadata, this.ref);
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.ref.deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.delete(new DeletionInfo(delTime));
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.delete(new DeletionInfo(tombstone, this.getComparator()));
    }

    @Override
    public void delete(DeletionInfo info) {
        DeletionInfo curDelInfo;
        DeletionInfo newDelInfo;
        Holder current;
        if (info.isLive()) {
            return;
        }
        while (!refUpdater.compareAndSet(this, current = this.ref, current.with(newDelInfo = info.mayModify(curDelInfo = current.deletionInfo) ? curDelInfo.copy().add(info) : curDelInfo))) {
        }
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.ref = this.ref.with(newInfo);
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        DeletionInfo purgedInfo;
        Holder current;
        do {
            current = this.ref;
            if (!current.deletionInfo.hasPurgeableTombstones(gcBefore)) break;
            purgedInfo = current.deletionInfo.copy();
            purgedInfo.purge(gcBefore);
        } while (!refUpdater.compareAndSet(this, current, current.with(purgedInfo)));
    }

    public long addAllWithSizeDelta(ColumnFamily cm, MemtableAllocator allocator, OpOrder.Group writeOp, SecondaryIndexManager.Updater indexer) {
        DeletionInfo deletionInfo;
        Holder current;
        Object[] tree;
        ColumnUpdater updater = new ColumnUpdater(this, cm.metadata, allocator, writeOp, indexer);
        do {
            updater.ref = current = this.ref;
            updater.reset();
            if (cm.deletionInfo().mayModify(current.deletionInfo)) {
                deletionInfo = current.deletionInfo.copy().add(cm.deletionInfo());
                updater.allocated(deletionInfo.unsharedHeapSize() - current.deletionInfo.unsharedHeapSize());
                continue;
            }
            deletionInfo = current.deletionInfo;
        } while ((tree = BTree.update(current.tree, this.metadata.comparator.columnComparator(), cm, cm.getColumnCount(), true, updater)) == null || !refUpdater.compareAndSet(this, current, new Holder(tree, deletionInfo)));
        indexer.updateRowLevelIndexes();
        updater.finish();
        return updater.dataSize;
    }

    @Override
    public void addColumn(Cell column) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(ColumnFamily cf) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell getColumn(CellName name) {
        return (Cell)((Object)BTree.find(this.ref.tree, this.asymmetricComparator(), name));
    }

    private Comparator<Object> asymmetricComparator() {
        final CellNameType cmp = this.metadata.comparator;
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return cmp.compare((CellName)o1, ((Cell)o2).name());
            }
        };
    }

    @Override
    public Iterable<CellName> getColumnNames() {
        return this.collection(false, NAME);
    }

    @Override
    public Collection<Cell> getSortedColumns() {
        return this.collection(true, Functions.identity());
    }

    @Override
    public Collection<Cell> getReverseSortedColumns() {
        return this.collection(false, Functions.identity());
    }

    private <V> Collection<V> collection(final boolean forwards, final Function<Cell, V> f) {
        final Holder ref = this.ref;
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return Iterators.transform(BTree.slice(ref.tree, forwards), (Function)f);
            }

            @Override
            public int size() {
                return BTree.slice(ref.tree, true).count();
            }
        };
    }

    @Override
    public int getColumnCount() {
        return BTree.slice(this.ref.tree, true).count();
    }

    @Override
    public boolean hasColumns() {
        return !BTree.isEmpty(this.ref.tree);
    }

    @Override
    public Iterator<Cell> iterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableSetIterator(new BTreeSet<Cell>(this.ref.tree, this.getComparator().columnComparator()), slices);
    }

    @Override
    public Iterator<Cell> reverseIterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableSetIterator(new BTreeSet<Cell>(this.ref.tree, this.getComparator().columnComparator()).descendingSet(), slices);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    private static final class ColumnUpdater
    implements UpdateFunction<Cell> {
        final AtomicBTreeColumns updating;
        final CFMetaData metadata;
        final MemtableAllocator allocator;
        final OpOrder.Group writeOp;
        final SecondaryIndexManager.Updater indexer;
        Holder ref;
        long dataSize;
        long heapSize;
        final MemtableAllocator.DataReclaimer reclaimer;
        List<Cell> inserted;

        private ColumnUpdater(AtomicBTreeColumns updating, CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group writeOp, SecondaryIndexManager.Updater indexer) {
            this.updating = updating;
            this.allocator = allocator;
            this.writeOp = writeOp;
            this.indexer = indexer;
            this.metadata = metadata;
            this.reclaimer = allocator.reclaimer();
        }

        public Cell apply(Cell insert) {
            this.indexer.insert(insert);
            insert = insert.localCopy(this.metadata, this.allocator, this.writeOp);
            this.dataSize += (long)insert.cellDataSize();
            this.heapSize += insert.excessHeapSizeExcludingData();
            if (this.inserted == null) {
                this.inserted = new ArrayList<Cell>();
            }
            this.inserted.add(insert);
            return insert;
        }

        @Override
        public Cell apply(Cell existing, Cell update) {
            Cell reconciled = existing.reconcile(update);
            this.indexer.update(existing, reconciled);
            if (existing != reconciled) {
                reconciled = reconciled.localCopy(this.metadata, this.allocator, this.writeOp);
                this.dataSize += (long)(reconciled.cellDataSize() - existing.cellDataSize());
                this.heapSize += reconciled.excessHeapSizeExcludingData() - existing.excessHeapSizeExcludingData();
                if (this.inserted == null) {
                    this.inserted = new ArrayList<Cell>();
                }
                this.inserted.add(reconciled);
                this.discard(existing);
            }
            return reconciled;
        }

        protected void reset() {
            this.dataSize = 0L;
            this.heapSize = 0L;
            if (this.inserted != null) {
                for (Cell cell : this.inserted) {
                    this.abort(cell);
                }
                this.inserted.clear();
            }
            this.reclaimer.cancel();
        }

        protected void abort(Cell abort) {
            this.reclaimer.reclaimImmediately(abort);
        }

        protected void discard(Cell discard) {
            this.reclaimer.reclaim(discard);
        }

        @Override
        public boolean abortEarly() {
            return this.updating.ref != this.ref;
        }

        @Override
        public void allocated(long heapSize) {
            this.heapSize += heapSize;
        }

        protected void finish() {
            this.allocator.onHeap().allocate(this.heapSize, this.writeOp);
            this.reclaimer.commit();
        }
    }

    private static final class Holder {
        final DeletionInfo deletionInfo;
        final Object[] tree;

        Holder(Object[] tree, DeletionInfo deletionInfo) {
            this.tree = tree;
            this.deletionInfo = deletionInfo;
        }

        Holder with(DeletionInfo info) {
            return new Holder(this.tree, info);
        }

        private Iterator<Cell> cellRange(Comparator<Cell> comparator, Composite start, Composite finish) {
            return new ColumnSlice.NavigableSetIterator(new BTreeSet<Cell>(this.tree, comparator), new ColumnSlice[]{new ColumnSlice(start, finish)});
        }
    }
}

