/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.statements.RawSelector;
import org.apache.cassandra.cql3.statements.Selectable;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Selection {
    private final List<ColumnDefinition> columnsList;
    private final ResultSet.Metadata metadata;
    private final boolean collectTimestamps;
    private final boolean collectTTLs;

    protected Selection(List<ColumnDefinition> columnsList, List<ColumnSpecification> metadata, boolean collectTimestamps, boolean collectTTLs) {
        this.columnsList = columnsList;
        this.metadata = new ResultSet.Metadata(metadata);
        this.collectTimestamps = collectTimestamps;
        this.collectTTLs = collectTTLs;
    }

    public boolean isWildcard() {
        return false;
    }

    public ResultSet.Metadata getResultMetadata() {
        return this.metadata;
    }

    public static Selection wildcard(CFMetaData cfm) {
        ArrayList<ColumnDefinition> all = new ArrayList<ColumnDefinition>(cfm.allColumns().size());
        Iterators.addAll(all, cfm.allColumnsInSelectOrder());
        return new SimpleSelection(all, true);
    }

    public static Selection forColumns(List<ColumnDefinition> columnsList) {
        return new SimpleSelection(columnsList, false);
    }

    public int addColumnForOrdering(ColumnDefinition c) {
        this.columnsList.add(c);
        this.metadata.addNonSerializedColumn(c);
        return this.columnsList.size() - 1;
    }

    private static boolean isUsingFunction(List<RawSelector> rawSelectors) {
        for (RawSelector rawSelector : rawSelectors) {
            if (rawSelector.selectable instanceof ColumnIdentifier) continue;
            return true;
        }
        return false;
    }

    private static int addAndGetIndex(ColumnDefinition def, List<ColumnDefinition> l) {
        int idx = l.indexOf(def);
        if (idx < 0) {
            idx = l.size();
            l.add(def);
        }
        return idx;
    }

    private static Selector makeSelector(CFMetaData cfm, RawSelector raw, List<ColumnDefinition> defs, List<ColumnSpecification> metadata) throws InvalidRequestException {
        if (raw.selectable instanceof ColumnIdentifier) {
            ColumnDefinition def = cfm.getColumnDefinition((ColumnIdentifier)raw.selectable);
            if (def == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", raw.selectable));
            }
            if (metadata != null) {
                metadata.add(raw.alias == null ? def : Selection.makeAliasSpec(cfm, def.type, raw.alias));
            }
            return new SimpleSelector(def.name.toString(), Selection.addAndGetIndex(def, defs), def.type);
        }
        if (raw.selectable instanceof Selectable.WritetimeOrTTL) {
            Selectable.WritetimeOrTTL tot = (Selectable.WritetimeOrTTL)raw.selectable;
            ColumnDefinition def = cfm.getColumnDefinition(tot.id);
            if (def == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", tot.id));
            }
            if (def.isPrimaryKeyColumn()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", tot.isWritetime ? "writeTime" : "ttl", def.name));
            }
            if (def.type.isCollection()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on collections", tot.isWritetime ? "writeTime" : "ttl"));
            }
            if (metadata != null) {
                metadata.add(Selection.makeWritetimeOrTTLSpec(cfm, tot, raw.alias));
            }
            return new WritetimeOrTTLSelector(def.name.toString(), Selection.addAndGetIndex(def, defs), tot.isWritetime);
        }
        if (raw.selectable instanceof Selectable.WithFieldSelection) {
            Selectable.WithFieldSelection withField = (Selectable.WithFieldSelection)raw.selectable;
            Selector selected = Selection.makeSelector(cfm, new RawSelector(withField.selected, null), defs, null);
            AbstractType<?> type = selected.getType();
            if (!(type instanceof UserType)) {
                throw new InvalidRequestException(String.format("Invalid field selection: %s of type %s is not a user type", withField.selected, type.asCQL3Type()));
            }
            UserType ut = (UserType)type;
            for (int i = 0; i < ut.types.size(); ++i) {
                if (!ut.columnNames.get(i).equals(withField.field.bytes)) continue;
                if (metadata != null) {
                    metadata.add(Selection.makeFieldSelectSpec(cfm, withField, (AbstractType)ut.types.get(i), raw.alias));
                }
                return new FieldSelector(ut, i, selected);
            }
            throw new InvalidRequestException(String.format("%s of type %s has no field %s", withField.selected, type.asCQL3Type(), withField.field));
        }
        Selectable.WithFunction withFun = (Selectable.WithFunction)raw.selectable;
        ArrayList<Selector> args = new ArrayList<Selector>(withFun.args.size());
        for (Selectable rawArg : withFun.args) {
            args.add(Selection.makeSelector(cfm, new RawSelector(rawArg, null), defs, null));
        }
        AbstractType<?> returnType = Functions.getReturnType(withFun.functionName, cfm.ksName, cfm.cfName);
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function '%s'", withFun.functionName));
        }
        ColumnSpecification spec = Selection.makeFunctionSpec(cfm, withFun, returnType, raw.alias);
        Function fun = Functions.get(cfm.ksName, withFun.functionName, args, spec);
        if (metadata != null) {
            metadata.add(spec);
        }
        return new FunctionSelector(fun, args);
    }

    private static ColumnSpecification makeWritetimeOrTTLSpec(CFMetaData cfm, Selectable.WritetimeOrTTL tot, ColumnIdentifier alias) {
        return new ColumnSpecification(cfm.ksName, cfm.cfName, alias == null ? new ColumnIdentifier(tot.toString(), true) : alias, tot.isWritetime ? LongType.instance : Int32Type.instance);
    }

    private static ColumnSpecification makeFieldSelectSpec(CFMetaData cfm, Selectable.WithFieldSelection s, AbstractType<?> type, ColumnIdentifier alias) {
        return new ColumnSpecification(cfm.ksName, cfm.cfName, alias == null ? new ColumnIdentifier(s.toString(), true) : alias, type);
    }

    private static ColumnSpecification makeFunctionSpec(CFMetaData cfm, Selectable.WithFunction fun, AbstractType<?> returnType, ColumnIdentifier alias) throws InvalidRequestException {
        if (returnType == null) {
            throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", fun.functionName));
        }
        return new ColumnSpecification(cfm.ksName, cfm.cfName, alias == null ? new ColumnIdentifier(fun.toString(), true) : alias, returnType);
    }

    private static ColumnSpecification makeAliasSpec(CFMetaData cfm, AbstractType<?> type, ColumnIdentifier alias) {
        return new ColumnSpecification(cfm.ksName, cfm.cfName, alias, type);
    }

    public static Selection fromSelectors(CFMetaData cfm, List<RawSelector> rawSelectors) throws InvalidRequestException {
        boolean usesFunction = Selection.isUsingFunction(rawSelectors);
        if (usesFunction) {
            ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>();
            ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
            ArrayList<Selector> selectors = new ArrayList<Selector>(rawSelectors.size());
            boolean collectTimestamps = false;
            boolean collectTTLs = false;
            for (RawSelector rawSelector : rawSelectors) {
                Selector selector = Selection.makeSelector(cfm, rawSelector, defs, metadata);
                selectors.add(selector);
                if (!(selector instanceof WritetimeOrTTLSelector)) continue;
                collectTimestamps |= ((WritetimeOrTTLSelector)selector).isWritetime;
                collectTTLs |= !((WritetimeOrTTLSelector)selector).isWritetime;
            }
            return new SelectionWithFunctions(defs, metadata, selectors, collectTimestamps, collectTTLs);
        }
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>(rawSelectors.size());
        ArrayList<ColumnSpecification> metadata = new ArrayList<ColumnSpecification>(rawSelectors.size());
        for (RawSelector rawSelector : rawSelectors) {
            assert (rawSelector.selectable instanceof ColumnIdentifier);
            ColumnDefinition def = cfm.getColumnDefinition((ColumnIdentifier)rawSelector.selectable);
            if (def == null) {
                throw new InvalidRequestException(String.format("Undefined name %s in selection clause", rawSelector.selectable));
            }
            defs.add(def);
            metadata.add(rawSelector.alias == null ? def : Selection.makeAliasSpec(cfm, def.type, rawSelector.alias));
        }
        return new SimpleSelection(defs, metadata, false);
    }

    protected abstract List<ByteBuffer> handleRow(ResultSetBuilder var1) throws InvalidRequestException;

    public List<ColumnDefinition> getColumnsList() {
        return this.columnsList;
    }

    public ResultSetBuilder resultSetBuilder(long now) {
        return new ResultSetBuilder(now);
    }

    private static ByteBuffer value(Cell c) {
        return c instanceof CounterCell ? ByteBufferUtil.bytes(CounterContext.instance().total(c.value())) : c.value();
    }

    private static class SelectionWithFunctions
    extends Selection {
        private final List<Selector> selectors;

        public SelectionWithFunctions(List<ColumnDefinition> columnsList, List<ColumnSpecification> metadata, List<Selector> selectors, boolean collectTimestamps, boolean collectTTLs) {
            super(columnsList, metadata, collectTimestamps, collectTTLs);
            this.selectors = selectors;
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
            for (Selector selector : this.selectors) {
                result.add(selector.compute(rs));
            }
            return result;
        }
    }

    private static class WritetimeOrTTLSelector
    extends Selector {
        private final String columnName;
        private final int idx;
        private final boolean isWritetime;

        public WritetimeOrTTLSelector(String columnName, int idx, boolean isWritetime) {
            this.columnName = columnName;
            this.idx = idx;
            this.isWritetime = isWritetime;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            if (this.isWritetime) {
                long ts = rs.timestamps[this.idx];
                return ts >= 0L ? ByteBufferUtil.bytes(ts) : null;
            }
            int ttl = rs.ttls[this.idx];
            return ttl > 0 ? ByteBufferUtil.bytes(ttl) : null;
        }

        @Override
        public AbstractType<?> getType() {
            return this.isWritetime ? LongType.instance : Int32Type.instance;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private static class FieldSelector
    extends Selector {
        private final UserType type;
        private final int field;
        private final Selector selected;

        public FieldSelector(UserType type, int field, Selector selected) {
            this.type = type;
            this.field = field;
            this.selected = selected;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) throws InvalidRequestException {
            ByteBuffer[] buffers = this.type.split(this.selected.compute(rs));
            return this.field < buffers.length ? buffers[this.field] : null;
        }

        @Override
        public AbstractType<?> getType() {
            return (AbstractType)this.type.types.get(this.field);
        }

        public String toString() {
            return String.format("%s.%s", this.selected, UTF8Type.instance.getString(this.type.columnNames.get(this.field)));
        }
    }

    private static class FunctionSelector
    extends Selector {
        private final Function fun;
        private final List<Selector> argSelectors;

        public FunctionSelector(Function fun, List<Selector> argSelectors) {
            this.fun = fun;
            this.argSelectors = argSelectors;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) throws InvalidRequestException {
            ArrayList<ByteBuffer> args = new ArrayList<ByteBuffer>(this.argSelectors.size());
            for (Selector s : this.argSelectors) {
                args.add(s.compute(rs));
            }
            return this.fun.execute(args);
        }

        @Override
        public AbstractType<?> getType() {
            return this.fun.returnType();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fun.name()).append("(");
            for (int i = 0; i < this.argSelectors.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.argSelectors.get(i));
            }
            return sb.append(")").toString();
        }
    }

    private static class SimpleSelector
    extends Selector {
        private final String columnName;
        private final int idx;
        private final AbstractType<?> type;

        public SimpleSelector(String columnName, int idx, AbstractType<?> type) {
            this.columnName = columnName;
            this.idx = idx;
            this.type = type;
        }

        @Override
        public ByteBuffer compute(ResultSetBuilder rs) {
            return rs.current.get(this.idx);
        }

        @Override
        public AbstractType<?> getType() {
            return this.type;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private static abstract class Selector
    implements AssignementTestable {
        private Selector() {
        }

        public abstract ByteBuffer compute(ResultSetBuilder var1) throws InvalidRequestException;

        public abstract AbstractType<?> getType();

        @Override
        public boolean isAssignableTo(String keyspace, ColumnSpecification receiver) {
            return this.getType().asCQL3Type().equals(receiver.type.asCQL3Type());
        }
    }

    private static class SimpleSelection
    extends Selection {
        private final boolean isWildcard;

        public SimpleSelection(List<ColumnDefinition> columnsList, boolean isWildcard) {
            this(columnsList, new ArrayList<ColumnSpecification>(columnsList), isWildcard);
        }

        public SimpleSelection(List<ColumnDefinition> columnsList, List<ColumnSpecification> metadata, boolean isWildcard) {
            super(columnsList, metadata, false, false);
            this.isWildcard = isWildcard;
        }

        @Override
        protected List<ByteBuffer> handleRow(ResultSetBuilder rs) {
            return rs.current;
        }

        @Override
        public boolean isWildcard() {
            return this.isWildcard;
        }
    }

    public class ResultSetBuilder {
        private final ResultSet resultSet;
        List<ByteBuffer> current;
        final long[] timestamps;
        final int[] ttls;
        final long now;

        private ResultSetBuilder(long now) {
            this.resultSet = new ResultSet(Selection.this.getResultMetadata(), new ArrayList<List<ByteBuffer>>());
            this.timestamps = Selection.this.collectTimestamps ? new long[Selection.this.columnsList.size()] : null;
            this.ttls = Selection.this.collectTTLs ? new int[Selection.this.columnsList.size()] : null;
            this.now = now;
        }

        public void add(ByteBuffer v) {
            this.current.add(v);
        }

        public void add(Cell c) {
            this.current.add(this.isDead(c) ? null : Selection.value(c));
            if (this.timestamps != null) {
                long l = this.timestamps[this.current.size() - 1] = this.isDead(c) ? -1L : c.timestamp();
            }
            if (this.ttls != null) {
                int ttl = -1;
                if (!this.isDead(c) && c instanceof ExpiringCell) {
                    ttl = c.getLocalDeletionTime() - (int)(this.now / 1000L);
                }
                this.ttls[this.current.size() - 1] = ttl;
            }
        }

        private boolean isDead(Cell c) {
            return c == null || !c.isLive(this.now);
        }

        public void newRow() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
            }
            this.current = new ArrayList<ByteBuffer>(Selection.this.columnsList.size());
        }

        public ResultSet build() throws InvalidRequestException {
            if (this.current != null) {
                this.resultSet.addRow(Selection.this.handleRow(this));
                this.current = null;
            }
            return this.resultSet;
        }
    }
}

