/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.Pool;

class PoolCleanerThread<P extends Pool>
extends Thread {
    final P pool;
    final Runnable cleaner;
    final WaitQueue wait = new WaitQueue();

    PoolCleanerThread(P pool, Runnable cleaner) {
        super(pool.getClass().getSimpleName() + "Cleaner");
        this.pool = pool;
        this.cleaner = cleaner;
    }

    boolean needsCleaning() {
        return ((Pool)this.pool).needsCleaning();
    }

    void trigger() {
        this.wait.signal();
    }

    @Override
    public void run() {
        while (true) {
            if (!this.needsCleaning()) {
                WaitQueue.Signal signal = this.wait.register();
                if (!this.needsCleaning()) {
                    signal.awaitUninterruptibly();
                    continue;
                }
                signal.cancel();
                continue;
            }
            this.cleaner.run();
        }
    }
}

