/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.ContextAllocator;
import org.apache.cassandra.utils.memory.Pool;

public abstract class PoolAllocator<P extends Pool>
extends AbstractAllocator {
    public final P pool;
    volatile LifeCycle state = LifeCycle.LIVE;
    private AtomicLong owns = new AtomicLong();
    private AtomicLong reclaiming = new AtomicLong();

    PoolAllocator(P pool) {
        this.pool = pool;
    }

    public void setDiscarding() {
        this.state = this.state.transition(LifeCycle.DISCARDING);
        long prev = this.reclaiming.get();
        long cur = this.owns.get();
        this.reclaiming.set(cur);
        ((Pool)this.pool).adjustReclaiming(cur - prev);
    }

    public void setDiscarded() {
        this.state = this.state.transition(LifeCycle.DISCARDED);
        ((Pool)this.pool).release(this.owns.getAndSet(0L));
        ((Pool)this.pool).adjustReclaiming(-this.reclaiming.get());
    }

    public abstract ByteBuffer allocate(int var1, OpOrder.Group var2);

    public abstract void free(ByteBuffer var1);

    protected void markAllocated(int size, OpOrder.Group opGroup) {
        while (true) {
            if (((Pool)this.pool).tryAllocate(size)) {
                this.acquired(size);
                return;
            }
            WaitQueue.Signal signal = opGroup.isBlockingSignal(((Pool)this.pool).hasRoom.register());
            boolean allocated = ((Pool)this.pool).tryAllocate(size);
            if (allocated || opGroup.isBlocking()) {
                signal.cancel();
                if (allocated) {
                    this.acquired(size);
                } else {
                    this.allocated(size);
                }
                return;
            }
            signal.awaitUninterruptibly();
        }
    }

    private void allocated(int size) {
        ((Pool)this.pool).adjustAllocated(size);
        this.owns.addAndGet(size);
    }

    private void acquired(int size) {
        this.owns.addAndGet(size);
    }

    void release(int size) {
        ((Pool)this.pool).release(size);
        this.owns.addAndGet(-size);
    }

    public boolean isLive() {
        return this.state == LifeCycle.LIVE;
    }

    public ByteBuffer clone(ByteBuffer buffer, OpOrder.Group opGroup) {
        assert (buffer != null);
        if (buffer.remaining() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(buffer.remaining(), opGroup);
        cloned.mark();
        cloned.put(buffer.duplicate());
        cloned.reset();
        return cloned;
    }

    public ContextAllocator wrap(OpOrder.Group opGroup, ColumnFamilyStore cfs) {
        return new ContextAllocator(opGroup, this, cfs);
    }

    @Override
    public long owns() {
        return this.owns.get();
    }

    @Override
    public float ownershipRatio() {
        return (float)this.owns.get() / (float)((Pool)this.pool).limit;
    }

    @Override
    public long reclaiming() {
        return this.reclaiming.get();
    }

    static final class LifeCycle
    extends Enum<LifeCycle> {
        public static final /* enum */ LifeCycle LIVE = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDING = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDED = new LifeCycle();
        private static final /* synthetic */ LifeCycle[] $VALUES;

        public static LifeCycle[] values() {
            return (LifeCycle[])$VALUES.clone();
        }

        public static LifeCycle valueOf(String name) {
            return Enum.valueOf(LifeCycle.class, name);
        }

        LifeCycle transition(LifeCycle target) {
            assert (target.ordinal() == this.ordinal() + 1);
            return target;
        }

        static {
            $VALUES = new LifeCycle[]{LIVE, DISCARDING, DISCARDED};
        }
    }
}

