/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.PoolAllocator;
import org.apache.cassandra.utils.memory.PoolCleanerThread;

public abstract class Pool {
    public final long limit;
    public final float cleanThreshold;
    private AtomicLong allocated = new AtomicLong();
    private AtomicLong reclaiming = new AtomicLong();
    final WaitQueue hasRoom = new WaitQueue();
    private volatile long nextClean;
    private final PoolCleanerThread<?> cleanerThread;

    public Pool(long limit, float cleanThreshold, Runnable cleaner) {
        this.limit = limit;
        this.cleanThreshold = cleanThreshold;
        this.updateNextClean();
        PoolCleanerThread<Pool> poolCleanerThread = this.cleanerThread = cleaner == null ? null : new PoolCleanerThread<Pool>(this, cleaner);
        if (this.cleanerThread != null) {
            this.cleanerThread.start();
        }
    }

    boolean needsCleaning() {
        return this.used() >= this.nextClean && this.updateNextClean() && this.cleanerThread != null;
    }

    void maybeClean() {
        if (this.needsCleaning()) {
            this.cleanerThread.trigger();
        }
    }

    private boolean updateNextClean() {
        long reclaiming = this.reclaiming.get();
        this.nextClean = reclaiming + (long)((float)this.limit * this.cleanThreshold);
        return this.used() >= this.nextClean;
    }

    boolean tryAllocate(int size) {
        long cur;
        do {
            if ((cur = this.allocated.get()) + (long)size <= this.limit) continue;
            return false;
        } while (!this.allocated.compareAndSet(cur, cur + (long)size));
        this.maybeClean();
        return true;
    }

    void adjustAllocated(long size) {
        long cur;
        if (size == 0L) {
            return;
        }
        while (!this.allocated.compareAndSet(cur = this.allocated.get(), cur + size)) {
        }
        if (size > 0L) {
            this.maybeClean();
        }
    }

    void release(long size) {
        this.adjustAllocated(-size);
        this.hasRoom.signalAll();
    }

    void adjustReclaiming(long reclaiming) {
        if (reclaiming == 0L) {
            return;
        }
        this.reclaiming.addAndGet(reclaiming);
        if (reclaiming < 0L && this.updateNextClean() && this.cleanerThread != null) {
            this.cleanerThread.trigger();
        }
    }

    public long allocated() {
        return this.allocated.get();
    }

    public long used() {
        return this.allocated.get();
    }

    public long reclaiming() {
        return this.reclaiming.get();
    }

    public abstract PoolAllocator newAllocator(OpOrder var1);
}

