/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import com.google.common.base.Function;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.PoolAllocator;

public final class ContextAllocator
extends AbstractAllocator
implements Function<Cell, Cell> {
    private final OpOrder.Group opGroup;
    private final PoolAllocator allocator;
    private final ColumnFamilyStore cfs;

    public ContextAllocator(OpOrder.Group opGroup, PoolAllocator allocator, ColumnFamilyStore cfs) {
        this.opGroup = opGroup;
        this.allocator = allocator;
        this.cfs = cfs;
    }

    @Override
    public ByteBuffer clone(ByteBuffer buffer) {
        return this.allocator.clone(buffer, this.opGroup);
    }

    @Override
    public ByteBuffer allocate(int size) {
        return this.allocator.allocate(size, this.opGroup);
    }

    public Cell apply(Cell column) {
        return column.localCopy(this.cfs, this);
    }

    @Override
    public long owns() {
        return this.allocator.owns();
    }

    @Override
    public float ownershipRatio() {
        return this.allocator.ownershipRatio();
    }

    @Override
    public long reclaiming() {
        return this.allocator.reclaiming();
    }
}

