/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractAllocator {
    public ByteBuffer clone(ByteBuffer buffer) {
        assert (buffer != null);
        if (buffer.remaining() == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer cloned = this.allocate(buffer.remaining());
        cloned.mark();
        cloned.put(buffer.duplicate());
        cloned.reset();
        return cloned;
    }

    public abstract ByteBuffer allocate(int var1);

    public long owns() {
        return 0L;
    }

    public float ownershipRatio() {
        return 0.0f;
    }

    public long reclaiming() {
        return 0L;
    }
}

