/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.Cursor;

public class BTreeSet<V>
implements NavigableSet<V> {
    protected final Comparator<V> comparator;
    protected final Object[] tree;

    public BTreeSet(Object[] tree, Comparator<V> comparator) {
        this.tree = tree;
        this.comparator = comparator;
    }

    public BTreeSet<V> update(Collection<V> updateWith, boolean isSorted) {
        return new BTreeSet<V>(BTree.update(this.tree, this.comparator, updateWith, isSorted, null), this.comparator);
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    protected Cursor<V> slice(boolean forwards, boolean permitInversion) {
        return BTree.slice(this.tree, forwards);
    }

    @Override
    public int size() {
        return this.slice(true, false).count();
    }

    @Override
    public boolean isEmpty() {
        return this.slice(true, false).hasNext();
    }

    @Override
    public Iterator<V> iterator() {
        return this.slice(true, true);
    }

    @Override
    public Iterator<V> descendingIterator() {
        return this.slice(false, true);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        int i = 0;
        for (V v : this) {
            a[i++] = v;
        }
        return a;
    }

    @Override
    public NavigableSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
        return new BTreeRange<V>(this.tree, this.comparator, fromElement, fromInclusive, toElement, toInclusive);
    }

    @Override
    public NavigableSet<V> headSet(V toElement, boolean inclusive) {
        return new BTreeRange<Object>(this.tree, (Comparator<Object>)this.comparator, null, true, toElement, inclusive);
    }

    @Override
    public NavigableSet<V> tailSet(V fromElement, boolean inclusive) {
        return new BTreeRange<Object>(this.tree, (Comparator<Object>)this.comparator, fromElement, inclusive, null, true);
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public V first() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V last() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V lower(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V floor(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V ceiling(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V higher(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<V> descendingSet() {
        return new BTreeRange<V>(this.tree, this.comparator).descendingSet();
    }

    public static class BTreeDescRange<V>
    extends BTreeRange<V> {
        BTreeDescRange(BTreeRange<V> from) {
            super(from.tree, from.comparator, from.lowerBound, from.inclusiveLowerBound, from.upperBound, from.inclusiveUpperBound);
        }

        @Override
        protected Cursor<V> slice(boolean forwards, boolean permitInversion) {
            return super.slice(permitInversion ? !forwards : forwards, false);
        }

        @Override
        public NavigableSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
            return super.subSet(toElement, toInclusive, fromElement, fromInclusive).descendingSet();
        }

        @Override
        public NavigableSet<V> headSet(V toElement, boolean inclusive) {
            return super.tailSet(toElement, inclusive).descendingSet();
        }

        @Override
        public NavigableSet<V> tailSet(V fromElement, boolean inclusive) {
            return super.headSet(fromElement, inclusive).descendingSet();
        }

        @Override
        public NavigableSet<V> descendingSet() {
            return new BTreeRange(this);
        }
    }

    public static class BTreeRange<V>
    extends BTreeSet<V>
    implements NavigableSet<V> {
        protected final V lowerBound;
        protected final V upperBound;
        protected final boolean inclusiveLowerBound;
        protected final boolean inclusiveUpperBound;

        BTreeRange(Object[] tree, Comparator<V> comparator) {
            this(tree, comparator, null, true, null, true);
        }

        BTreeRange(BTreeRange<V> from) {
            this(from.tree, from.comparator, from.lowerBound, from.inclusiveLowerBound, from.upperBound, from.inclusiveUpperBound);
        }

        BTreeRange(Object[] tree, Comparator<V> comparator, V lowerBound, boolean inclusiveLowerBound, V upperBound, boolean inclusiveUpperBound) {
            super(tree, comparator);
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.inclusiveLowerBound = inclusiveLowerBound;
            this.inclusiveUpperBound = inclusiveUpperBound;
        }

        BTreeRange(BTreeRange<V> a, BTreeRange<V> b) {
            super(a.tree, a.comparator);
            int c;
            assert (a.tree == b.tree);
            BTreeRange<V> lb = a.lowerBound == null ? b : (b.lowerBound == null ? a : ((c = this.comparator.compare(a.lowerBound, b.lowerBound)) < 0 ? b : (c > 0 ? a : (!a.inclusiveLowerBound ? a : b))));
            BTreeRange<V> ub = a.upperBound == null ? b : (b.upperBound == null ? a : ((c = this.comparator.compare(b.upperBound, a.upperBound)) < 0 ? b : (c > 0 ? a : (!a.inclusiveUpperBound ? a : b))));
            this.lowerBound = lb.lowerBound;
            this.inclusiveLowerBound = lb.inclusiveLowerBound;
            this.upperBound = ub.upperBound;
            this.inclusiveUpperBound = ub.inclusiveUpperBound;
        }

        @Override
        protected Cursor<V> slice(boolean forwards, boolean permitInversion) {
            return BTree.slice(this.tree, this.comparator, this.lowerBound, this.inclusiveLowerBound, this.upperBound, this.inclusiveUpperBound, forwards);
        }

        @Override
        public NavigableSet<V> subSet(V fromElement, boolean fromInclusive, V toElement, boolean toInclusive) {
            return new BTreeRange<V>(this, new BTreeRange<V>(this.tree, this.comparator, fromElement, fromInclusive, toElement, toInclusive));
        }

        @Override
        public NavigableSet<V> headSet(V toElement, boolean inclusive) {
            return new BTreeRange<V>(this, new BTreeRange<V>(this.tree, this.comparator, this.lowerBound, true, toElement, inclusive));
        }

        @Override
        public NavigableSet<V> tailSet(V fromElement, boolean inclusive) {
            return new BTreeRange<Object>(this, new BTreeRange<Object>(this.tree, this.comparator, fromElement, inclusive, null, true));
        }

        @Override
        public NavigableSet<V> descendingSet() {
            return new BTreeDescRange(this);
        }
    }
}

