/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.google.common.base.Objects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.UUIDSerializer;

public class StreamSummary
implements Serializable {
    public static final IVersionedSerializer<StreamSummary> serializer = new StreamSummarySerializer();
    public final UUID cfId;
    public final int files;
    public final long totalSize;

    public StreamSummary(UUID cfId, int files, long totalSize) {
        this.cfId = cfId;
        this.files = files;
        this.totalSize = totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSummary summary = (StreamSummary)o;
        return this.files == summary.files && this.totalSize == summary.totalSize && this.cfId.equals(summary.cfId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.cfId, this.files, this.totalSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamSummary{");
        sb.append("path=").append(this.cfId);
        sb.append(", files=").append(this.files);
        sb.append(", totalSize=").append(this.totalSize);
        sb.append('}');
        return sb.toString();
    }

    public static class StreamSummarySerializer
    implements IVersionedSerializer<StreamSummary> {
        @Override
        public void serialize(StreamSummary summary, DataOutput out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(summary.cfId, out, 8);
            out.writeInt(summary.files);
            out.writeLong(summary.totalSize);
        }

        @Override
        public StreamSummary deserialize(DataInput in, int version) throws IOException {
            UUID cfId = UUIDSerializer.serializer.deserialize(in, 8);
            int files = in.readInt();
            long totalSize = in.readLong();
            return new StreamSummary(cfId, files, totalSize);
        }

        @Override
        public long serializedSize(StreamSummary summary, int version) {
            long size = UUIDSerializer.serializer.serializedSize(summary.cfId, 8);
            size += (long)TypeSizes.NATIVE.sizeof(summary.files);
            return size += (long)TypeSizes.NATIVE.sizeof(summary.totalSize);
        }
    }
}

