/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.clearspring.analytics.stream.cardinality.ICardinality;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.StreamingHistogram;

public class MetadataCollector {
    public static final double NO_COMPRESSION_RATIO = -1.0;
    protected EstimatedHistogram estimatedRowSize = MetadataCollector.defaultRowSizeHistogram();
    protected EstimatedHistogram estimatedColumnCount = MetadataCollector.defaultColumnCountHistogram();
    protected ReplayPosition replayPosition = ReplayPosition.NONE;
    protected long minTimestamp = Long.MAX_VALUE;
    protected long maxTimestamp = Long.MIN_VALUE;
    protected int maxLocalDeletionTime = Integer.MIN_VALUE;
    protected double compressionRatio = -1.0;
    protected Set<Integer> ancestors = new HashSet<Integer>();
    protected StreamingHistogram estimatedTombstoneDropTime = MetadataCollector.defaultTombstoneDropTimeHistogram();
    protected int sstableLevel;
    protected List<ByteBuffer> minColumnNames = Collections.emptyList();
    protected List<ByteBuffer> maxColumnNames = Collections.emptyList();
    protected ICardinality cardinality = new HyperLogLogPlus(13, 25);
    private final CellNameType columnNameComparator;

    static EstimatedHistogram defaultColumnCountHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultRowSizeHistogram() {
        return new EstimatedHistogram(150);
    }

    static StreamingHistogram defaultTombstoneDropTimeHistogram() {
        return new StreamingHistogram(100);
    }

    public static StatsMetadata defaultStatsMetadata() {
        return new StatsMetadata(MetadataCollector.defaultRowSizeHistogram(), MetadataCollector.defaultColumnCountHistogram(), ReplayPosition.NONE, Long.MIN_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, -1.0, MetadataCollector.defaultTombstoneDropTimeHistogram(), 0, Collections.emptyList(), Collections.emptyList(), 0L);
    }

    public MetadataCollector(CellNameType columnNameComparator) {
        this.columnNameComparator = columnNameComparator;
    }

    public MetadataCollector(Collection<SSTableReader> sstables, CellNameType columnNameComparator, int level) {
        this(columnNameComparator);
        this.replayPosition(ReplayPosition.getReplayPosition(sstables));
        this.sstableLevel(level);
        for (SSTableReader sstable : sstables) {
            this.addAncestor(sstable.descriptor.generation);
            for (Integer i : sstable.getAncestors()) {
                if (!new File(sstable.descriptor.withGeneration(i).filenameFor(Component.DATA)).exists()) continue;
                this.addAncestor(i);
            }
        }
    }

    public void addKey(ByteBuffer key) {
        long hashed = MurmurHash.hash2_64(key, key.position(), key.remaining(), 0L);
        this.cardinality.offerHashed(hashed);
    }

    public void addRowSize(long rowSize) {
        this.estimatedRowSize.add(rowSize);
    }

    public void addColumnCount(long columnCount) {
        this.estimatedColumnCount.add(columnCount);
    }

    public void mergeTombstoneHistogram(StreamingHistogram histogram) {
        this.estimatedTombstoneDropTime.merge(histogram);
    }

    public void addCompressionRatio(long compressed, long uncompressed) {
        this.compressionRatio = (double)compressed / (double)uncompressed;
    }

    public void updateMinTimestamp(long potentialMin) {
        this.minTimestamp = Math.min(this.minTimestamp, potentialMin);
    }

    public void updateMaxTimestamp(long potentialMax) {
        this.maxTimestamp = Math.max(this.maxTimestamp, potentialMax);
    }

    public void updateMaxLocalDeletionTime(int maxLocalDeletionTime) {
        this.maxLocalDeletionTime = Math.max(this.maxLocalDeletionTime, maxLocalDeletionTime);
    }

    public MetadataCollector estimatedRowSize(EstimatedHistogram estimatedRowSize) {
        this.estimatedRowSize = estimatedRowSize;
        return this;
    }

    public MetadataCollector estimatedColumnCount(EstimatedHistogram estimatedColumnCount) {
        this.estimatedColumnCount = estimatedColumnCount;
        return this;
    }

    public MetadataCollector replayPosition(ReplayPosition replayPosition) {
        this.replayPosition = replayPosition;
        return this;
    }

    public MetadataCollector addAncestor(int generation) {
        this.ancestors.add(generation);
        return this;
    }

    public void update(long size, ColumnStats stats) {
        this.updateMinTimestamp(stats.minTimestamp);
        this.updateMaxTimestamp(stats.maxTimestamp);
        this.updateMaxLocalDeletionTime(stats.maxLocalDeletionTime);
        this.addRowSize(size);
        this.addColumnCount(stats.columnCount);
        this.mergeTombstoneHistogram(stats.tombstoneHistogram);
        this.updateMinColumnNames(stats.minColumnNames);
        this.updateMaxColumnNames(stats.maxColumnNames);
    }

    public MetadataCollector sstableLevel(int sstableLevel) {
        this.sstableLevel = sstableLevel;
        return this;
    }

    public MetadataCollector updateMinColumnNames(List<ByteBuffer> minColumnNames) {
        if (minColumnNames.size() > 0) {
            this.minColumnNames = ColumnNameHelper.mergeMin(this.minColumnNames, minColumnNames, this.columnNameComparator);
        }
        return this;
    }

    public MetadataCollector updateMaxColumnNames(List<ByteBuffer> maxColumnNames) {
        if (maxColumnNames.size() > 0) {
            this.maxColumnNames = ColumnNameHelper.mergeMax(this.maxColumnNames, maxColumnNames, this.columnNameComparator);
        }
        return this;
    }

    public Map<MetadataType, MetadataComponent> finalizeMetadata(String partitioner, double bloomFilterFPChance, long repairedAt) {
        HashMap components = Maps.newHashMap();
        components.put(MetadataType.VALIDATION, new ValidationMetadata(partitioner, bloomFilterFPChance));
        components.put(MetadataType.STATS, new StatsMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.minTimestamp, this.maxTimestamp, this.maxLocalDeletionTime, this.compressionRatio, this.estimatedTombstoneDropTime, this.sstableLevel, this.minColumnNames, this.maxColumnNames, repairedAt));
        components.put(MetadataType.COMPACTION, new CompactionMetadata(this.ancestors, this.cardinality));
        return components;
    }
}

