/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamPlan;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.Pair;

public class SSTableLoader
implements StreamEventHandler {
    private final File directory;
    private final String keyspace;
    private final Client client;
    private final OutputHandler outputHandler;
    private final Set<InetAddress> failedHosts = new HashSet<InetAddress>();
    private final List<SSTableReader> sstables = new ArrayList<SSTableReader>();
    private final Multimap<InetAddress, StreamSession.SSTableStreamingSections> streamingDetails = HashMultimap.create();

    public SSTableLoader(File directory, Client client, OutputHandler outputHandler) {
        this.directory = directory;
        this.keyspace = directory.getParentFile().getName();
        this.client = client;
        this.outputHandler = outputHandler;
    }

    protected Collection<SSTableReader> openSSTables(final Map<InetAddress, Collection<Range<Token>>> ranges) {
        this.outputHandler.output("Opening sstables and calculating sections to stream");
        this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                if (new File(dir, name).isDirectory()) {
                    return false;
                }
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (p == null || !((Component)p.right).equals(Component.DATA) || desc.temporary) {
                    return false;
                }
                if (!new File(desc.filenameFor(Component.PRIMARY_INDEX)).exists()) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s because index is missing", name));
                    return false;
                }
                CFMetaData metadata = SSTableLoader.this.client.getCFMetaData(SSTableLoader.this.keyspace, desc.cfname);
                if (metadata == null) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s: column family %s.%s doesn't exist", name, SSTableLoader.this.keyspace, desc.cfname));
                    return false;
                }
                HashSet<Component> components = new HashSet<Component>();
                components.add(Component.DATA);
                components.add(Component.PRIMARY_INDEX);
                if (new File(desc.filenameFor(Component.SUMMARY)).exists()) {
                    components.add(Component.SUMMARY);
                }
                if (new File(desc.filenameFor(Component.COMPRESSION_INFO)).exists()) {
                    components.add(Component.COMPRESSION_INFO);
                }
                if (new File(desc.filenameFor(Component.STATS)).exists()) {
                    components.add(Component.STATS);
                }
                try {
                    SSTableReader sstable = SSTableReader.openForBatch(desc, components, metadata, SSTableLoader.this.client.getPartitioner());
                    SSTableLoader.this.sstables.add(sstable);
                    for (Map.Entry entry : ranges.entrySet()) {
                        InetAddress endpoint = (InetAddress)entry.getKey();
                        Collection tokenRanges = (Collection)entry.getValue();
                        List<Pair<Long, Long>> sstableSections = sstable.getPositionsForRanges(tokenRanges);
                        long estimatedKeys = sstable.estimatedKeysForRanges(tokenRanges);
                        StreamSession.SSTableStreamingSections details = new StreamSession.SSTableStreamingSections(sstable, sstableSections, estimatedKeys, 0L);
                        SSTableLoader.this.streamingDetails.put((Object)endpoint, (Object)details);
                    }
                    sstable.releaseSummary();
                }
                catch (IOException e) {
                    SSTableLoader.this.outputHandler.output(String.format("Skipping file %s, error opening it: %s", name, e.getMessage()));
                }
                return false;
            }
        });
        return this.sstables;
    }

    public StreamResultFuture stream() {
        return this.stream(Collections.emptySet());
    }

    public StreamResultFuture stream(Set<InetAddress> toIgnore) {
        this.client.init(this.keyspace);
        this.outputHandler.output("Established connection to initial hosts");
        StreamPlan plan = new StreamPlan("Bulk Load");
        Map<InetAddress, Collection<Range<Token>>> endpointToRanges = this.client.getEndpointToRangesMap();
        this.openSSTables(endpointToRanges);
        if (this.sstables.isEmpty()) {
            return plan.execute();
        }
        this.outputHandler.output(String.format("Streaming relevant part of %sto %s", this.names(this.sstables), endpointToRanges.keySet()));
        for (Map.Entry<InetAddress, Collection<Range<Token>>> entry : endpointToRanges.entrySet()) {
            InetAddress remote = entry.getKey();
            if (toIgnore.contains(remote)) continue;
            Collection endpointDetails = this.streamingDetails.get((Object)remote);
            for (StreamSession.SSTableStreamingSections details : endpointDetails) {
                details.sstable.acquireReference();
            }
            plan.transferFiles(remote, this.streamingDetails.get((Object)remote));
        }
        StreamResultFuture bulkResult = plan.execute();
        bulkResult.addEventListener(this);
        return bulkResult;
    }

    public void onSuccess(StreamState finalState) {
    }

    public void onFailure(Throwable t) {
    }

    @Override
    public void handleStreamEvent(StreamEvent event) {
        if (event.eventType == StreamEvent.Type.STREAM_COMPLETE) {
            StreamEvent.SessionCompleteEvent se = (StreamEvent.SessionCompleteEvent)event;
            if (!se.success) {
                this.failedHosts.add(se.peer);
            }
        }
    }

    private String names(Collection<SSTableReader> sstables) {
        StringBuilder builder = new StringBuilder();
        for (SSTableReader sstable : sstables) {
            builder.append(sstable.descriptor.filenameFor(Component.DATA)).append(" ");
        }
        return builder.toString();
    }

    public Set<InetAddress> getFailedHosts() {
        return this.failedHosts;
    }

    static {
        Config.setClientMode(true);
    }

    public static abstract class Client {
        private final Map<InetAddress, Collection<Range<Token>>> endpointToRanges = new HashMap<InetAddress, Collection<Range<Token>>>();
        private IPartitioner partitioner;

        public abstract void init(String var1);

        public void stop() {
        }

        public abstract CFMetaData getCFMetaData(String var1, String var2);

        public Map<InetAddress, Collection<Range<Token>>> getEndpointToRangesMap() {
            return this.endpointToRanges;
        }

        protected void setPartitioner(String partclass) throws ConfigurationException {
            this.setPartitioner(FBUtilities.newPartitioner(partclass));
        }

        protected void setPartitioner(IPartitioner partitioner) {
            this.partitioner = partitioner;
            DatabaseDescriptor.setPartitioner(partitioner);
        }

        public IPartitioner getPartitioner() {
            return this.partitioner;
        }

        protected void addRangeForEndpoint(Range<Token> range, InetAddress endpoint) {
            Collection<Range<Token>> ranges = this.endpointToRanges.get(endpoint);
            if (ranges == null) {
                ranges = new HashSet<Range<Token>>();
                this.endpointToRanges.put(endpoint, ranges);
            }
            ranges.add(range);
        }
    }
}

