/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.IndexSummaryBuilder;
import org.apache.cassandra.io.sstable.IndexSummaryManagerMBean;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryManager
implements IndexSummaryManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryManager.class);
    public static final String MBEAN_NAME = "org.apache.cassandra.db:type=IndexSummaries";
    public static final IndexSummaryManager instance = new IndexSummaryManager();
    private int resizeIntervalInMinutes = 0;
    private long memoryPoolBytes;
    static final double UPSAMPLE_THRESHOLD = 1.5;
    static final double DOWNSAMPLE_THESHOLD = 0.75;
    private final DebuggableScheduledThreadPoolExecutor executor = new DebuggableScheduledThreadPoolExecutor(1, "IndexSummaryManager", 1);
    private ScheduledFuture future;

    private IndexSummaryManager() {
        long indexSummarySizeInMB = DatabaseDescriptor.getIndexSummaryCapacityInMB();
        int interval = DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes();
        logger.info("Initializing index summary manager with a memory pool size of {} MB and a resize interval of {} minutes", (Object)indexSummarySizeInMB, (Object)interval);
        this.setMemoryPoolCapacityInMB(DatabaseDescriptor.getIndexSummaryCapacityInMB());
        this.setResizeIntervalInMinutes(DatabaseDescriptor.getIndexSummaryResizeIntervalInMinutes());
    }

    @Override
    public int getResizeIntervalInMinutes() {
        return this.resizeIntervalInMinutes;
    }

    @Override
    public void setResizeIntervalInMinutes(int resizeIntervalInMinutes) {
        long initialDelay;
        int oldInterval = this.resizeIntervalInMinutes;
        this.resizeIntervalInMinutes = resizeIntervalInMinutes;
        if (this.future != null) {
            initialDelay = oldInterval < 0 ? (long)resizeIntervalInMinutes : Math.max(0L, (long)resizeIntervalInMinutes - ((long)oldInterval - this.future.getDelay(TimeUnit.MINUTES)));
            this.future.cancel(false);
        } else {
            initialDelay = resizeIntervalInMinutes;
        }
        if (this.resizeIntervalInMinutes < 0) {
            this.future = null;
            return;
        }
        this.future = this.executor.scheduleWithFixedDelay(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                IndexSummaryManager.this.redistributeSummaries();
            }
        }, initialDelay, resizeIntervalInMinutes, TimeUnit.MINUTES);
    }

    @VisibleForTesting
    Long getTimeToNextResize(TimeUnit timeUnit) {
        if (this.future == null) {
            return null;
        }
        return this.future.getDelay(timeUnit);
    }

    @Override
    public long getMemoryPoolCapacityInMB() {
        return this.memoryPoolBytes / 1024L / 1024L;
    }

    @Override
    public Map<String, Integer> getIndexIntervals() {
        List<SSTableReader> sstables = this.getAllSSTables();
        HashMap<String, Integer> intervals = new HashMap<String, Integer>(sstables.size());
        for (SSTableReader sstable : sstables) {
            intervals.put(sstable.getFilename(), (int)Math.round(sstable.getEffectiveIndexInterval()));
        }
        return intervals;
    }

    @Override
    public double getAverageIndexInterval() {
        List<SSTableReader> sstables = this.getAllSSTables();
        double total = 0.0;
        for (SSTableReader sstable : sstables) {
            total += sstable.getEffectiveIndexInterval();
        }
        return total / (double)sstables.size();
    }

    @Override
    public void setMemoryPoolCapacityInMB(long memoryPoolCapacityInMB) {
        this.memoryPoolBytes = memoryPoolCapacityInMB * 1024L * 1024L;
    }

    @Override
    public double getMemoryPoolSizeInMB() {
        long total = 0L;
        for (SSTableReader sstable : this.getAllSSTables()) {
            total += sstable.getIndexSummaryOffHeapSize();
        }
        return (double)total / 1024.0 / 1024.0;
    }

    private List<SSTableReader> getAllSSTables() {
        ArrayList<SSTableReader> result = new ArrayList<SSTableReader>();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                result.addAll(cfStore.getSSTables());
            }
        }
        return result;
    }

    private Pair<List<SSTableReader>, Multimap<DataTracker, SSTableReader>> getCompactingAndNonCompactingSSTables() {
        ArrayList allCompacting = new ArrayList();
        HashMultimap allNonCompacting = HashMultimap.create();
        for (Keyspace ks : Keyspace.all()) {
            for (ColumnFamilyStore cfStore : ks.getColumnFamilyStores()) {
                Set<SSTableReader> allSSTables;
                HashSet nonCompacting;
                do {
                    allSSTables = cfStore.getDataTracker().getSSTables();
                } while (!(nonCompacting = Sets.newHashSet(cfStore.getDataTracker().getUncompactingSSTables(allSSTables))).isEmpty() && !cfStore.getDataTracker().markCompacting(nonCompacting));
                allNonCompacting.putAll((Object)cfStore.getDataTracker(), (Iterable)nonCompacting);
                allCompacting.addAll(Sets.difference(allSSTables, (Set)nonCompacting));
            }
        }
        return Pair.create(allCompacting, allNonCompacting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redistributeSummaries() throws IOException {
        Pair<List<SSTableReader>, Multimap<DataTracker, SSTableReader>> compactingAndNonCompacting = this.getCompactingAndNonCompactingSSTables();
        try {
            IndexSummaryManager.redistributeSummaries((List)compactingAndNonCompacting.left, Lists.newArrayList((Iterable)((Multimap)compactingAndNonCompacting.right).values()), this.memoryPoolBytes);
        }
        finally {
            for (DataTracker tracker : ((Multimap)compactingAndNonCompacting.right).keySet()) {
                tracker.unmarkCompacting(((Multimap)compactingAndNonCompacting.right).get((Object)tracker));
            }
        }
    }

    @VisibleForTesting
    public static List<SSTableReader> redistributeSummaries(List<SSTableReader> compacting, List<SSTableReader> nonCompacting, long memoryPoolBytes) throws IOException {
        long total = 0L;
        for (SSTableReader sstable : Iterables.concat(compacting, nonCompacting)) {
            total += sstable.getIndexSummaryOffHeapSize();
        }
        logger.debug("Beginning redistribution of index summaries for {} sstables with memory pool size {} MB; current spaced used is {} MB", new Object[]{nonCompacting.size(), memoryPoolBytes / 1024L / 1024L, (double)total / 1024.0 / 1024.0});
        double totalReadsPerSec = 0.0;
        for (SSTableReader sstable : nonCompacting) {
            if (sstable.readMeter == null) continue;
            totalReadsPerSec += sstable.readMeter.fifteenMinuteRate();
        }
        logger.trace("Total reads/sec across all sstables in index summary resize process: {}", (Object)totalReadsPerSec);
        ArrayList<SSTableReader> sstablesByHotness = new ArrayList<SSTableReader>(nonCompacting);
        Collections.sort(sstablesByHotness, new Comparator<SSTableReader>(){

            @Override
            public int compare(SSTableReader o1, SSTableReader o2) {
                if (o1.readMeter == null && o2.readMeter == null) {
                    return 0;
                }
                if (o1.readMeter == null) {
                    return -1;
                }
                if (o2.readMeter == null) {
                    return 1;
                }
                return Double.compare(o1.readMeter.fifteenMinuteRate(), o2.readMeter.fifteenMinuteRate());
            }
        });
        long remainingBytes = memoryPoolBytes;
        for (SSTableReader sstable : compacting) {
            remainingBytes -= sstable.getIndexSummaryOffHeapSize();
        }
        logger.trace("Index summaries for compacting SSTables are using {} MB of space", (Object)((double)(memoryPoolBytes - remainingBytes) / 1024.0 / 1024.0));
        List<SSTableReader> newSSTables = IndexSummaryManager.adjustSamplingLevels(sstablesByHotness, totalReadsPerSec, remainingBytes);
        total = 0L;
        for (SSTableReader sstable : Iterables.concat(compacting, newSSTables)) {
            total += sstable.getIndexSummaryOffHeapSize();
        }
        logger.debug("Completed resizing of index summaries; current approximate memory used: {} MB", (Object)((double)total / 1024.0 / 1024.0));
        return newSSTables;
    }

    private static List<SSTableReader> adjustSamplingLevels(List<SSTableReader> sstables, double totalReadsPerSec, long memoryPoolCapacity) throws IOException {
        List<ResampleEntry> toDownsample = new ArrayList<ResampleEntry>(sstables.size() / 4);
        ArrayList<ResampleEntry> toUpsample = new ArrayList<ResampleEntry>(sstables.size() / 4);
        ArrayList<ResampleEntry> forceResample = new ArrayList<ResampleEntry>();
        ArrayList<ResampleEntry> forceUpsample = new ArrayList<ResampleEntry>();
        ArrayList<SSTableReader> newSSTables = new ArrayList<SSTableReader>(sstables.size());
        long remainingSpace = memoryPoolCapacity;
        for (SSTableReader sstable : sstables) {
            long spaceUsed;
            int minIndexInterval = sstable.metadata.getMinIndexInterval();
            int maxIndexInterval = sstable.metadata.getMaxIndexInterval();
            double readsPerSec = sstable.readMeter == null ? 0.0 : sstable.readMeter.fifteenMinuteRate();
            long idealSpace = Math.round((double)remainingSpace * (readsPerSec / totalReadsPerSec));
            int currentNumEntries = sstable.getIndexSummarySize();
            double avgEntrySize = (double)sstable.getIndexSummaryOffHeapSize() / (double)currentNumEntries;
            long targetNumEntries = Math.max(1L, Math.round((double)idealSpace / avgEntrySize));
            int currentSamplingLevel = sstable.getIndexSummarySamplingLevel();
            int maxSummarySize = sstable.getMaxIndexSummarySize();
            if (sstable.getMinIndexInterval() != minIndexInterval) {
                int effectiveSamplingLevel = (int)Math.round((double)currentSamplingLevel * ((double)minIndexInterval / (double)sstable.getMinIndexInterval()));
                maxSummarySize = (int)Math.round((double)maxSummarySize * ((double)sstable.getMinIndexInterval() / (double)minIndexInterval));
                logger.trace("min_index_interval changed from {} to {}, so the current sampling level for {} is effectively now {} (was {})", new Object[]{sstable.getMinIndexInterval(), minIndexInterval, sstable, effectiveSamplingLevel, currentSamplingLevel});
                currentSamplingLevel = effectiveSamplingLevel;
            }
            int newSamplingLevel = IndexSummaryBuilder.calculateSamplingLevel(currentSamplingLevel, currentNumEntries, targetNumEntries, minIndexInterval, maxIndexInterval);
            int numEntriesAtNewSamplingLevel = IndexSummaryBuilder.entriesAtSamplingLevel(newSamplingLevel, maxSummarySize);
            double effectiveIndexInterval = sstable.getEffectiveIndexInterval();
            logger.trace("{} has {} reads/sec; ideal space for index summary: {} bytes ({} entries); considering moving from level {} ({} entries, {} bytes) to level {} ({} entries, {} bytes)", new Object[]{sstable.getFilename(), readsPerSec, idealSpace, targetNumEntries, currentSamplingLevel, currentNumEntries, (double)currentNumEntries * avgEntrySize, newSamplingLevel, numEntriesAtNewSamplingLevel, (double)numEntriesAtNewSamplingLevel * avgEntrySize});
            if (effectiveIndexInterval < (double)minIndexInterval) {
                logger.debug("Forcing resample of {} because the current index interval ({}) is below min_index_interval ({})", new Object[]{sstable, effectiveIndexInterval, minIndexInterval});
                spaceUsed = (long)Math.ceil(avgEntrySize * (double)numEntriesAtNewSamplingLevel);
                forceResample.add(new ResampleEntry(sstable, spaceUsed, newSamplingLevel));
                remainingSpace -= spaceUsed;
            } else if (effectiveIndexInterval > (double)maxIndexInterval) {
                logger.debug("Forcing upsample of {} because the current index interval ({}) is above max_index_interval ({})", new Object[]{sstable, effectiveIndexInterval, maxIndexInterval});
                newSamplingLevel = Math.max(1, 128 * minIndexInterval / maxIndexInterval);
                numEntriesAtNewSamplingLevel = IndexSummaryBuilder.entriesAtSamplingLevel(newSamplingLevel, sstable.getMaxIndexSummarySize());
                spaceUsed = (long)Math.ceil(avgEntrySize * (double)numEntriesAtNewSamplingLevel);
                forceUpsample.add(new ResampleEntry(sstable, spaceUsed, newSamplingLevel));
                remainingSpace = (long)((double)remainingSpace - avgEntrySize * (double)numEntriesAtNewSamplingLevel);
            } else if ((double)targetNumEntries >= (double)currentNumEntries * 1.5 && newSamplingLevel > currentSamplingLevel) {
                spaceUsed = (long)Math.ceil(avgEntrySize * (double)numEntriesAtNewSamplingLevel);
                toUpsample.add(new ResampleEntry(sstable, spaceUsed, newSamplingLevel));
                remainingSpace = (long)((double)remainingSpace - avgEntrySize * (double)numEntriesAtNewSamplingLevel);
            } else if ((double)targetNumEntries < (double)currentNumEntries * 0.75 && newSamplingLevel < currentSamplingLevel) {
                spaceUsed = (long)Math.ceil(avgEntrySize * (double)numEntriesAtNewSamplingLevel);
                toDownsample.add(new ResampleEntry(sstable, spaceUsed, newSamplingLevel));
                remainingSpace -= spaceUsed;
            } else {
                logger.trace("SSTable {} is within thresholds of ideal sampling", (Object)sstable);
                remainingSpace -= sstable.getIndexSummaryOffHeapSize();
                newSSTables.add(sstable);
            }
            totalReadsPerSec -= readsPerSec;
        }
        if (remainingSpace > 0L) {
            Pair<List<SSTableReader>, List<ResampleEntry>> result = IndexSummaryManager.distributeRemainingSpace(toDownsample, remainingSpace);
            toDownsample = (List)result.right;
            newSSTables.addAll((Collection)result.left);
        }
        toDownsample.addAll(forceResample);
        toDownsample.addAll(toUpsample);
        toDownsample.addAll(forceUpsample);
        HashMultimap replacedByTracker = HashMultimap.create();
        HashMultimap replacementsByTracker = HashMultimap.create();
        for (ResampleEntry entry : toDownsample) {
            SSTableReader sstable = entry.sstable;
            logger.debug("Re-sampling index summary for {} from {}/{} to {}/{} of the original number of entries", new Object[]{sstable, sstable.getIndexSummarySamplingLevel(), 128, entry.newSamplingLevel, 128});
            SSTableReader replacement = sstable.cloneWithNewSummarySamplingLevel(entry.newSamplingLevel);
            DataTracker tracker = Keyspace.open(sstable.getKeyspaceName()).getColumnFamilyStore(sstable.getColumnFamilyName()).getDataTracker();
            replacedByTracker.put((Object)tracker, (Object)sstable);
            replacementsByTracker.put((Object)tracker, (Object)replacement);
        }
        for (DataTracker tracker : replacedByTracker.keySet()) {
            tracker.replaceReaders(replacedByTracker.get((Object)tracker), replacementsByTracker.get((Object)tracker));
            newSSTables.addAll(replacementsByTracker.get((Object)tracker));
        }
        return newSSTables;
    }

    @VisibleForTesting
    static Pair<List<SSTableReader>, List<ResampleEntry>> distributeRemainingSpace(List<ResampleEntry> toDownsample, long remainingSpace) {
        int noDownsampleCutoff;
        long extraSpaceRequired;
        Collections.sort(toDownsample, new Comparator<ResampleEntry>(){

            @Override
            public int compare(ResampleEntry o1, ResampleEntry o2) {
                return Double.compare(o1.sstable.getIndexSummaryOffHeapSize() - o1.newSpaceUsed, o2.sstable.getIndexSummaryOffHeapSize() - o2.newSpaceUsed);
            }
        });
        ArrayList<SSTableReader> willNotDownsample = new ArrayList<SSTableReader>();
        for (noDownsampleCutoff = 0; remainingSpace > 0L && noDownsampleCutoff < toDownsample.size(); remainingSpace -= extraSpaceRequired, ++noDownsampleCutoff) {
            ResampleEntry entry = toDownsample.get(noDownsampleCutoff);
            extraSpaceRequired = entry.sstable.getIndexSummaryOffHeapSize() - entry.newSpaceUsed;
            if (extraSpaceRequired > remainingSpace) break;
            logger.trace("Using leftover space to keep {} at the current sampling level ({})", (Object)entry.sstable, (Object)entry.sstable.getIndexSummarySamplingLevel());
            willNotDownsample.add(entry.sstable);
        }
        return Pair.create(willNotDownsample, toDownsample.subList(noDownsampleCutoff, toDownsample.size()));
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ResampleEntry {
        public final SSTableReader sstable;
        public final long newSpaceUsed;
        public final int newSamplingLevel;

        public ResampleEntry(SSTableReader sstable, long newSpaceUsed, int newSamplingLevel) {
            this.sstable = sstable;
            this.newSpaceUsed = newSpaceUsed;
            this.newSamplingLevel = newSamplingLevel;
        }
    }
}

