/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Downsampling;
import org.apache.cassandra.io.sstable.IndexSummary;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSummaryBuilder {
    private static final Logger logger = LoggerFactory.getLogger(IndexSummaryBuilder.class);
    private final ArrayList<Long> positions;
    private final ArrayList<byte[]> keys;
    private final int minIndexInterval;
    private final int samplingLevel;
    private final int[] startPoints;
    private long keysWritten = 0L;
    private long indexIntervalMatches = 0L;
    private long offheapSize = 0L;

    public IndexSummaryBuilder(long expectedKeys, int minIndexInterval, int samplingLevel) {
        this.samplingLevel = samplingLevel;
        this.startPoints = Downsampling.getStartPoints(128, samplingLevel);
        long maxExpectedEntries = expectedKeys / (long)minIndexInterval;
        if (maxExpectedEntries > Integer.MAX_VALUE) {
            int effectiveMinInterval = (int)Math.ceil(2.147483647E9 / (double)expectedKeys);
            maxExpectedEntries = expectedKeys / (long)effectiveMinInterval;
            assert (maxExpectedEntries <= Integer.MAX_VALUE) : maxExpectedEntries;
            logger.warn("min_index_interval of {} is too low for {} expected keys; using interval of {} instead", new Object[]{minIndexInterval, expectedKeys, effectiveMinInterval});
            this.minIndexInterval = effectiveMinInterval;
        } else {
            this.minIndexInterval = minIndexInterval;
        }
        maxExpectedEntries = maxExpectedEntries * (long)samplingLevel / 128L;
        this.positions = new ArrayList((int)maxExpectedEntries);
        this.keys = new ArrayList((int)maxExpectedEntries);
    }

    public IndexSummaryBuilder maybeAddEntry(DecoratedKey decoratedKey, long indexPosition) {
        if (this.keysWritten % (long)this.minIndexInterval == 0L) {
            boolean shouldSkip = false;
            for (int start : this.startPoints) {
                if ((this.indexIntervalMatches - (long)start) % 128L != 0L) continue;
                shouldSkip = true;
                break;
            }
            if (!shouldSkip) {
                byte[] key = ByteBufferUtil.getArray(decoratedKey.key);
                this.keys.add(key);
                this.offheapSize += (long)key.length;
                this.positions.add(indexPosition);
                this.offheapSize += (long)TypeSizes.NATIVE.sizeof(indexPosition);
            }
            ++this.indexIntervalMatches;
        }
        ++this.keysWritten;
        return this;
    }

    public IndexSummary build(IPartitioner partitioner) {
        assert (this.keys.size() > 0);
        assert (this.keys.size() == this.positions.size());
        Memory memory = Memory.allocate(this.offheapSize + (long)(this.keys.size() * 4));
        int idxPosition = 0;
        int keyPosition = this.keys.size() * 4;
        for (int i = 0; i < this.keys.size(); ++i) {
            memory.setInt(idxPosition, keyPosition);
            idxPosition += TypeSizes.NATIVE.sizeof(keyPosition);
            byte[] keyBytes = this.keys.get(i);
            memory.setBytes(keyPosition, keyBytes, 0, keyBytes.length);
            long actualIndexPosition = this.positions.get(i);
            memory.setLong(keyPosition += keyBytes.length, actualIndexPosition);
            keyPosition += TypeSizes.NATIVE.sizeof(actualIndexPosition);
        }
        int sizeAtFullSampling = (int)Math.ceil((double)this.keysWritten / (double)this.minIndexInterval);
        return new IndexSummary(partitioner, memory, this.keys.size(), sizeAtFullSampling, this.minIndexInterval, this.samplingLevel);
    }

    public static int entriesAtSamplingLevel(int samplingLevel, int maxSummarySize) {
        return (int)Math.ceil((double)(samplingLevel * maxSummarySize) / 128.0);
    }

    public static int calculateSamplingLevel(int currentSamplingLevel, int currentNumEntries, long targetNumEntries, int minIndexInterval, int maxIndexInterval) {
        int effectiveMinSamplingLevel = Math.max(1, (int)Math.ceil((double)(128 * minIndexInterval) / (double)maxIndexInterval));
        int newSamplingLevel = (int)(targetNumEntries * (long)currentSamplingLevel) / currentNumEntries;
        return Math.min(128, Math.max(effectiveMinSamplingLevel, newSamplingLevel));
    }

    public static IndexSummary downsample(IndexSummary existing, int newSamplingLevel, int minIndexInterval, IPartitioner partitioner) {
        int currentSamplingLevel = existing.getSamplingLevel();
        assert (currentSamplingLevel > newSamplingLevel);
        assert (minIndexInterval == existing.getMinIndexInterval());
        int[] startPoints = Downsampling.getStartPoints(currentSamplingLevel, newSamplingLevel);
        int removedKeyCount = 0;
        long newOffHeapSize = existing.getOffHeapSize();
        int[] arr$ = startPoints;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int start;
            for (int j = start = arr$[i$]; j < existing.size(); j += currentSamplingLevel) {
                ++removedKeyCount;
                newOffHeapSize -= (long)existing.getEntry(j).length;
            }
        }
        int newKeyCount = existing.size() - removedKeyCount;
        Memory memory = Memory.allocate(newOffHeapSize - (long)(removedKeyCount * 4));
        int idxPosition = 0;
        int keyPosition = newKeyCount * 4;
        block2: for (int oldSummaryIndex = 0; oldSummaryIndex < existing.size(); ++oldSummaryIndex) {
            for (int start : startPoints) {
                if ((oldSummaryIndex - start) % currentSamplingLevel == 0) continue block2;
            }
            memory.setInt(idxPosition, keyPosition);
            idxPosition += TypeSizes.NATIVE.sizeof(keyPosition);
            byte[] entry = existing.getEntry(oldSummaryIndex);
            memory.setBytes(keyPosition, entry, 0, entry.length);
            keyPosition += entry.length;
        }
        return new IndexSummary(partitioner, memory, newKeyCount, existing.getMaxNumberOfEntries(), minIndexInterval, newSamplingLevel);
    }
}

