/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.utils.Pair;

public class UserType
extends CompositeType {
    public final String keyspace;
    public final ByteBuffer name;
    public final List<ByteBuffer> columnNames;

    public UserType(String keyspace, ByteBuffer name, List<ByteBuffer> columnNames, List<AbstractType<?>> types) {
        super(types);
        this.keyspace = keyspace;
        this.name = name;
        this.columnNames = columnNames;
    }

    public static UserType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        Pair<Pair<String, ByteBuffer>, List<Pair<ByteBuffer, AbstractType>>> params = parser.getUserTypeParameters();
        String keyspace = (String)((Pair)params.left).left;
        ByteBuffer name = (ByteBuffer)((Pair)params.left).right;
        ArrayList<ByteBuffer> columnNames = new ArrayList<ByteBuffer>(((List)params.right).size());
        ArrayList columnTypes = new ArrayList(((List)params.right).size());
        for (Pair p : (List)params.right) {
            columnNames.add((ByteBuffer)p.left);
            columnTypes.add((AbstractType<?>)p.right);
        }
        return new UserType(keyspace, name, columnNames, columnTypes);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.keyspace, this.name, this.columnNames, this.types});
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType that = (UserType)o;
        return this.keyspace.equals(that.keyspace) && this.name.equals(that.name) && this.columnNames.equals(that.columnNames) && this.types.equals(that.types);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.UserDefined.create(this);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyUserTypeParameters(this.keyspace, this.name, this.columnNames, this.types);
    }
}

