/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.Pair;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new HashMap();
    public final AbstractType<K> keys;
    public final AbstractType<V> values;
    private final MapSerializer<K, V> serializer;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0), l.get(1));
    }

    public static synchronized <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values) {
        Pair<AbstractType<K>, AbstractType<V>> p = Pair.create(keys, values);
        MapType<K, V> t = instances.get(p);
        if (t == null) {
            t = new MapType<K, V>(keys, values);
            instances.put(p, t);
        }
        return t;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values) {
        super(CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
        this.serializer = MapSerializer.getInstance(keys.getSerializer(), values.getSerializer());
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public TypeSerializer<Map<K, V>> getSerializer() {
        return this.serializer;
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values)));
    }

    @Override
    public ByteBuffer serialize(List<Cell> cells) {
        cells = this.enforceLimit(cells);
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(2 * cells.size());
        int size = 0;
        for (Cell c : cells) {
            ByteBuffer key = c.name().collectionElement();
            ByteBuffer value = c.value();
            bbs.add(key);
            bbs.add(value);
            size += 4 + key.remaining() + value.remaining();
        }
        return MapType.pack(bbs, cells.size(), size);
    }
}

