/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionType<T>
extends AbstractType<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollectionType.class);
    public static final int MAX_ELEMENTS = 65535;
    public final Kind kind;

    protected CollectionType(Kind kind) {
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    protected abstract void appendToStringBuilder(StringBuilder var1);

    public abstract ByteBuffer serialize(List<Cell> var1);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb);
        return sb.toString();
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        throw new UnsupportedOperationException("CollectionType should not be use directly as a comparator");
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public void validate(ByteBuffer bytes) {
        this.valueComparator().validate(bytes);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    protected static ByteBuffer pack(List<ByteBuffer> buffers, int elements, int size) {
        ByteBuffer result = ByteBuffer.allocate(2 + size);
        result.putShort((short)elements);
        for (ByteBuffer bb : buffers) {
            result.putShort((short)bb.remaining());
            result.put(bb.duplicate());
        }
        return (ByteBuffer)result.flip();
    }

    protected List<Cell> enforceLimit(List<Cell> cells) {
        if (cells.size() <= 65535) {
            return cells;
        }
        logger.error("Detected collection with {} elements, more than the {} limit. Only the first {} elements will be returned to the client. Please see http://cassandra.apache.org/doc/cql3/CQL.html#collections for more details.", new Object[]{cells.size(), 65535, 65535});
        return cells.subList(0, 65535);
    }

    public static ByteBuffer pack(List<ByteBuffer> buffers, int elements) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            size += 2 + bb.remaining();
        }
        return CollectionType.pack(buffers, elements, size);
    }

    protected static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    public static enum Kind {
        MAP,
        SET,
        LIST;

    }
}

