/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.keys;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.keys.KeysSearcher;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.ConfigurationException;

public class KeysIndex
extends AbstractSimplePerColumnSecondaryIndex {
    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.value();
    }

    @Override
    protected CellName makeIndexColumnName(ByteBuffer rowKey, Cell cell) {
        return CellNames.simpleDense(rowKey);
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new KeysSearcher(this.baseCfs.indexManager, columns);
    }

    public boolean isIndexEntryStale(ByteBuffer indexedValue, ColumnFamily data, long now) {
        Cell liveCell = data.getColumn(data.getComparator().makeCellName(this.columnDef.name.bytes));
        if (liveCell == null || liveCell.isMarkedForDelete(now)) {
            return true;
        }
        ByteBuffer liveValue = liveCell.value();
        return this.columnDef.type.compare(indexedValue, liveValue) != 0;
    }

    @Override
    public void validateOptions() throws ConfigurationException {
    }

    @Override
    public boolean indexes(CellName name) {
        AbstractType<?> comparator = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return comparator.compare(this.columnDef.name.bytes, name.toByteBuffer()) == 0;
    }

    @Override
    protected AbstractType getExpressionComparator() {
        return this.baseCfs.getComparator().asAbstractType();
    }
}

