/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;

public class CompositesIndexOnCollectionKey
extends CompositesIndex {
    public static CellNameType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int count = 1 + baseMetadata.clusteringColumns().size();
        ArrayList types = new ArrayList(count);
        types.add(SecondaryIndex.keyComparator);
        for (int i = 0; i < count - 1; ++i) {
            types.add(baseMetadata.comparator.subtype(i));
        }
        return new CompoundDenseCellNameType(types);
    }

    @Override
    protected AbstractType<?> getIndexKeyComparator() {
        return ((CollectionType)this.columnDef.type).nameComparator();
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.name().get(this.columnDef.position() + 1);
    }

    @Override
    protected Composite makeIndexColumnPrefix(ByteBuffer rowKey, Composite cellName) {
        int count = 1 + this.baseCfs.metadata.clusteringColumns().size();
        CBuilder builder = this.getIndexComparator().builder();
        builder.add(rowKey);
        for (int i = 0; i < count - 1; ++i) {
            builder.add(cellName.get(i));
        }
        return builder.build();
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Cell indexEntry) {
        int count = 1 + this.baseCfs.metadata.clusteringColumns().size();
        CBuilder builder = this.baseCfs.getComparator().builder();
        for (int i = 0; i < count - 1; ++i) {
            builder.add(indexEntry.name().get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), indexEntry.name().get(0), builder.build());
    }

    @Override
    public boolean indexes(CellName name) {
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return name.size() > this.columnDef.position() && comp.compare(name.get(this.columnDef.position()), this.columnDef.name.bytes) == 0;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        CellName name = data.getComparator().create(entry.indexedEntryPrefix, this.columnDef.name, entry.indexValue.key);
        Cell liveCell = data.getColumn(name);
        return liveCell == null || liveCell.isMarkedForDelete(now);
    }
}

