/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.cql3.CQL3Row;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.AbstractSimpleCellNameType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.SimpleSparseCellName;
import org.apache.cassandra.db.composites.SimpleSparseInternedCellName;
import org.apache.cassandra.db.marshal.AbstractType;

public class SimpleSparseCellNameType
extends AbstractSimpleCellNameType {
    private final Map<ByteBuffer, CellName> internedNames;

    public SimpleSparseCellNameType(AbstractType<?> type) {
        this(type, new HashMap<ByteBuffer, CellName>());
    }

    private SimpleSparseCellNameType(AbstractType<?> type, Map<ByteBuffer, CellName> internedNames) {
        super(type);
        this.internedNames = internedNames;
    }

    @Override
    public int clusteringPrefixSize() {
        return 0;
    }

    @Override
    public CellNameType setSubtype(int position, AbstractType<?> newType) {
        if (position != 0) {
            throw new IllegalArgumentException();
        }
        return new SimpleSparseCellNameType(newType, this.internedNames);
    }

    @Override
    public CBuilder prefixBuilder() {
        return Composites.EMPTY_BUILDER;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public CellName create(Composite prefix, ColumnIdentifier columnName) {
        assert (prefix.isEmpty());
        CellName cn = this.internedNames.get(columnName.bytes);
        return cn == null ? new SimpleSparseCellName(columnName) : cn;
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bb) {
        if (!bb.hasRemaining()) {
            return Composites.EMPTY;
        }
        CellName cn = this.internedNames.get(bb);
        return cn == null ? new SimpleSparseCellName(new ColumnIdentifier(bb, this.type)) : cn;
    }

    @Override
    public void addCQL3Column(ColumnIdentifier id) {
        this.internedNames.put(id.bytes, new SimpleSparseInternedCellName(id));
    }

    @Override
    public void removeCQL3Column(ColumnIdentifier id) {
        this.internedNames.remove(id.bytes);
    }

    @Override
    public CQL3Row.Builder CQL3RowBuilder(long now) {
        return SimpleSparseCellNameType.makeSparseCQL3RowBuilder(now);
    }
}

