/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.SimpleComposite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class SimpleDenseCellName
extends SimpleComposite
implements CellName {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new SimpleDenseCellName(ByteBuffer.allocate(1)));

    SimpleDenseCellName(ByteBuffer element) {
        super(element);
    }

    @Override
    public int clusteringSize() {
        return 1;
    }

    @Override
    public ColumnIdentifier cql3ColumnName() {
        return null;
    }

    @Override
    public ByteBuffer collectionElement() {
        return null;
    }

    @Override
    public boolean isCollectionCell() {
        return false;
    }

    @Override
    public boolean isSameCQL3RowAs(CellName other) {
        return this.equals(other);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.element);
    }

    @Override
    public long excessHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.element);
    }

    @Override
    public CellName copy(AbstractAllocator allocator) {
        return new SimpleDenseCellName(allocator.clone(this.element));
    }
}

