/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.composites.AbstractCType;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.composites.SimpleComposite;
import org.apache.cassandra.db.composites.SimpleDenseCellName;
import org.apache.cassandra.db.marshal.AbstractType;

public class SimpleCType
extends AbstractCType {
    protected final AbstractType<?> type;

    public SimpleCType(AbstractType<?> type) {
        this.type = type;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AbstractType<?> subtype(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.type;
    }

    @Override
    public Composite fromByteBuffer(ByteBuffer bytes) {
        return !bytes.hasRemaining() ? Composites.EMPTY : new SimpleComposite(bytes);
    }

    @Override
    public CBuilder builder() {
        return new SimpleCBuilder(this);
    }

    @Override
    public CType setSubtype(int position, AbstractType<?> newType) {
        if (position != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new SimpleCType(newType);
    }

    @Override
    public AbstractType<?> asAbstractType() {
        return this.type;
    }

    public static class SimpleCBuilder
    implements CBuilder {
        private final CType type;
        private ByteBuffer value;

        public SimpleCBuilder(CType type) {
            this.type = type;
        }

        @Override
        public int remainingCount() {
            return this.value == null ? 1 : 0;
        }

        @Override
        public CBuilder add(ByteBuffer value) {
            if (this.value != null) {
                throw new IllegalStateException();
            }
            this.value = value;
            return this;
        }

        @Override
        public CBuilder add(Object value) {
            return this.add(this.type.subtype(0).decompose(value));
        }

        @Override
        public Composite build() {
            if (this.value == null || !this.value.hasRemaining()) {
                return Composites.EMPTY;
            }
            if (this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new SimpleDenseCellName(this.value);
            }
            return new SimpleComposite(this.value);
        }

        @Override
        public Composite buildWith(ByteBuffer value) {
            if (this.value != null) {
                throw new IllegalStateException();
            }
            if (value == null || !value.hasRemaining()) {
                return Composites.EMPTY;
            }
            if (this.type instanceof CellNameType && ((CellNameType)this.type).isDense()) {
                return new SimpleDenseCellName(value);
            }
            return new SimpleComposite(value);
        }
    }
}

